/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.recipes.PrimitiveBlastFurnaceRecipe;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityPrimitiveBlastFurnace
extends MultiblockControllerBase {
    private int maxProgressDuration;
    private int currentProgress;
    private NonNullList<ItemStack> outputsList;
    private int fuelUnitsLeft;
    private boolean isActive;
    private boolean wasActiveAndNeedUpdate;
    private ItemStack lastInputStack = ItemStack.field_190927_a;
    private PrimitiveBlastFurnaceRecipe previousRecipe;

    public MetaTileEntityPrimitiveBlastFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    protected void updateFormedValid() {
        if (this.maxProgressDuration == 0) {
            if (this.tryPickNewRecipe()) {
                if (this.wasActiveAndNeedUpdate) {
                    this.wasActiveAndNeedUpdate = false;
                } else {
                    this.setActive(true);
                }
            }
        } else if (++this.currentProgress >= this.maxProgressDuration) {
            this.finishCurrentRecipe();
            this.wasActiveAndNeedUpdate = true;
            return;
        }
        if (this.wasActiveAndNeedUpdate) {
            this.wasActiveAndNeedUpdate = false;
            this.setActive(false);
        }
    }

    private void finishCurrentRecipe() {
        this.maxProgressDuration = 0;
        this.currentProgress = 0;
        MetaTileEntity.addItemsToItemHandler((IItemHandler)this.exportItems, false, this.outputsList);
        this.outputsList = null;
        this.markDirty();
    }

    private PrimitiveBlastFurnaceRecipe getOrRefreshRecipe(ItemStack inputStack) {
        PrimitiveBlastFurnaceRecipe currentRecipe = null;
        if (this.previousRecipe != null && this.previousRecipe.getInput().getIngredient().apply(inputStack)) {
            currentRecipe = this.previousRecipe;
        } else if (!ItemStack.func_179545_c((ItemStack)this.lastInputStack, (ItemStack)inputStack) || !ItemStack.func_77970_a((ItemStack)this.lastInputStack, (ItemStack)inputStack)) {
            this.lastInputStack = inputStack.func_77946_l();
            currentRecipe = RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.stream().filter(it -> it.getInput().getIngredient().test((Object)inputStack)).findFirst().orElse(null);
            if (currentRecipe != null) {
                this.previousRecipe = currentRecipe;
            }
        }
        return currentRecipe;
    }

    private boolean setupRecipe(ItemStack inputStack, int fuelAmount, PrimitiveBlastFurnaceRecipe recipe) {
        return inputStack.func_190916_E() >= recipe.getInput().getCount() && fuelAmount >= recipe.getFuelAmount() && ItemHandlerHelper.insertItemStacked((IItemHandler)this.exportItems, (ItemStack)recipe.getOutput(), (boolean)true).func_190926_b();
    }

    private boolean tryPickNewRecipe() {
        ItemStack inputStack = this.importItems.getStackInSlot(0);
        ItemStack fuelStack = this.importItems.getStackInSlot(1);
        if (inputStack.func_190926_b() || fuelStack.func_190926_b() && this.fuelUnitsLeft == 0) {
            return false;
        }
        int fuelUnitsPerItem = this.getFuelUnits(fuelStack);
        int totalFuelUnits = this.fuelUnitsLeft + fuelUnitsPerItem * fuelStack.func_190916_E();
        PrimitiveBlastFurnaceRecipe currentRecipe = this.getOrRefreshRecipe(inputStack);
        if (currentRecipe != null && this.setupRecipe(inputStack, totalFuelUnits, currentRecipe)) {
            inputStack.func_190918_g(currentRecipe.getInput().getCount());
            int fuelUnitsToConsume = currentRecipe.getFuelAmount();
            int remainderConsumed = Math.min(fuelUnitsToConsume, this.fuelUnitsLeft);
            int fuelItemsToConsume = (int)Math.ceil((double)(fuelUnitsToConsume -= remainderConsumed) / ((double)fuelUnitsPerItem * 1.0));
            int remainderAdded = fuelItemsToConsume * fuelUnitsPerItem - fuelUnitsToConsume;
            this.fuelUnitsLeft += remainderAdded - remainderConsumed;
            fuelStack.func_190918_g(fuelItemsToConsume);
            this.maxProgressDuration = currentRecipe.getDuration();
            this.currentProgress = 0;
            NonNullList outputs = NonNullList.func_191196_a();
            outputs.add((Object)currentRecipe.getOutput().func_77946_l());
            outputs.add((Object)OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh, Math.max(1, Math.abs(3 - fuelUnitsPerItem))));
            this.outputsList = outputs;
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Active", this.isActive);
        data.func_74757_a("WasActive", this.wasActiveAndNeedUpdate);
        data.func_74768_a("FuelUnitsLeft", this.fuelUnitsLeft);
        data.func_74768_a("MaxProgress", this.maxProgressDuration);
        if (this.maxProgressDuration > 0) {
            data.func_74768_a("Progress", this.currentProgress);
            NBTTagList itemOutputs = new NBTTagList();
            for (ItemStack itemStack : this.outputsList) {
                itemOutputs.func_74742_a((NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
            }
            data.func_74782_a("Outputs", (NBTBase)itemOutputs);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("Active");
        this.wasActiveAndNeedUpdate = data.func_74767_n("WasActive");
        this.fuelUnitsLeft = data.func_74762_e("FuelUnitsLeft");
        this.maxProgressDuration = data.func_74762_e("MaxProgress");
        if (this.maxProgressDuration > 0) {
            this.currentProgress = data.func_74762_e("Progress");
            NBTTagList itemOutputs = data.func_150295_c("Outputs", 10);
            this.outputsList = NonNullList.func_191196_a();
            for (int i = 0; i < itemOutputs.func_74745_c(); ++i) {
                this.outputsList.add((Object)new ItemStack(itemOutputs.func_150305_b(i)));
            }
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isActive = buf.readBoolean();
            this.getWorld().func_175664_x(this.getPos());
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(100, b -> b.writeBoolean(this.isActive));
            this.getWorld().func_175664_x(this.getPos());
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public double getProgressScaled() {
        return this.maxProgressDuration == 0 ? 0.0 : (double)this.currentProgress / ((double)this.maxProgressDuration * 1.0);
    }

    @Override
    public int getLightValue(IMultiblockPart sourcePart) {
        return sourcePart == null && this.isActive ? 15 : 0;
    }

    protected int getFuelUnits(ItemStack fuelType) {
        if (fuelType.func_190926_b()) {
            return 0;
        }
        MaterialStack materialStack = OreDictUnifier.getMaterial(fuelType);
        if (materialStack != null && materialStack.amount >= 3628800L) {
            int materialAmount = (int)(materialStack.amount / 3628800L);
            if (materialStack.material == Materials.Coal || materialStack.material == Materials.Charcoal) {
                return materialAmount;
            }
            if (materialStack.material == Materials.Coke) {
                return 2 * materialAmount;
            }
        }
        if (OreDictUnifier.getOreDictionaryNames(fuelType).contains("fuelCoke")) {
            return 2;
        }
        return 0;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.PRIMITIVE_BRICKS);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PRIMITIVE_BRICKS;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.PRIMITIVE_BLAST_FURNACE_OVERLAY.render(renderState, translation, pipeline, this.getFrontFacing(), this.isActive());
        if (this.isActive() && this.isStructureFormed()) {
            EnumFacing back = this.getFrontFacing().func_176734_d();
            Matrix4 offset = translation.copy().translate((double)back.func_82601_c(), -0.3, (double)back.func_82599_e());
            TextureAtlasSprite sprite = TextureUtils.getBlockTexture((String)"lava_still");
            renderState.brightness = 0xF000F0;
            renderState.colour = -1;
            Textures.renderFace(renderState, offset, new IVertexOperation[0], EnumFacing.UP, Cuboid6.full, sprite);
        }
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        ItemStackHandler emptyHandler = new ItemStackHandler(0);
        this.itemInventory = new ItemHandlerProxy((IItemHandler)emptyHandler, (IItemHandler)emptyHandler);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(2){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 1 && MetaTileEntityPrimitiveBlastFurnace.this.getFuelUnits(stack) == 0) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(2);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX", "XXX").aisle("XXX", "X#X", "X#X", "X#X").aisle("XXX", "XYX", "XXX", "XXX").where('X', MetaTileEntityPrimitiveBlastFurnace.statePredicate(this.getCasingState())).where('#', MetaTileEntityPrimitiveBlastFurnace.isAirPredicate()).where('Y', this.selfPredicate()).build();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityPrimitiveBlastFurnace(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 166).widget(new SlotWidget(this.importItems, 0, 33, 15, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.INGOT_OVERLAY)).widget(new SlotWidget(this.importItems, 1, 33, 33, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FURNACE_OVERLAY)).progressBar(this::getProgressScaled, 58, 24, 20, 15, GuiTextures.BRONZE_BLAST_FURNACE_PROGRESS_BAR, ProgressWidget.MoveType.HORIZONTAL).widget(new SlotWidget(this.exportItems, 0, 85, 24, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.INGOT_OVERLAY)).widget(new SlotWidget(this.exportItems, 1, 103, 24, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.DUST_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT).build(this.getHolder(), entityPlayer);
    }
}

