/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemColorProvider;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.IItemNameProvider;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMaterialPartBehavior
implements IItemBehaviour,
IItemDurabilityManager,
IItemColorProvider,
IItemNameProvider {
    protected NBTTagCompound getPartStatsTag(ItemStack itemStack) {
        return itemStack.func_179543_a("GT.PartStats");
    }

    protected NBTTagCompound getOrCreatePartStatsTag(ItemStack itemStack) {
        return itemStack.func_190925_c("GT.PartStats");
    }

    public IngotMaterial getPartMaterial(ItemStack itemStack) {
        NBTTagCompound compound = this.getPartStatsTag(itemStack);
        IngotMaterial defaultMaterial = Materials.Darmstadtium;
        if (compound == null || !compound.func_150297_b("Material", 8)) {
            return defaultMaterial;
        }
        String materialName = compound.func_74779_i("Material");
        Material material = (Material)Material.MATERIAL_REGISTRY.func_82594_a(materialName);
        if (!(material instanceof IngotMaterial)) {
            return defaultMaterial;
        }
        return (IngotMaterial)material;
    }

    public void setPartMaterial(ItemStack itemStack, IngotMaterial material) {
        NBTTagCompound compound = this.getOrCreatePartStatsTag(itemStack);
        compound.func_74778_a("Material", material.toString());
    }

    public abstract int getPartMaxDurability(ItemStack var1);

    public int getPartDamage(ItemStack itemStack) {
        NBTTagCompound compound = this.getPartStatsTag(itemStack);
        if (compound == null || !compound.func_150297_b("Damage", 99)) {
            return 0;
        }
        return compound.func_74762_e("Damage");
    }

    public void setPartDamage(ItemStack itemStack, int rotorDamage) {
        NBTTagCompound compound = this.getOrCreatePartStatsTag(itemStack);
        compound.func_74768_a("Damage", Math.min(this.getPartMaxDurability(itemStack), rotorDamage));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getItemStackDisplayName(ItemStack itemStack, String unlocalizedName) {
        IngotMaterial material = this.getPartMaterial(itemStack);
        return I18n.func_135052_a((String)unlocalizedName, (Object[])new Object[]{material.getLocalizedName()});
    }

    @Override
    public void addInformation(ItemStack stack, List<String> lines) {
        IngotMaterial material = this.getPartMaterial(stack);
        int maxRotorDurability = this.getPartMaxDurability(stack);
        int rotorDamage = this.getPartDamage(stack);
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.durability", (Object[])new Object[]{maxRotorDurability - rotorDamage, maxRotorDurability}));
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{material.getLocalizedName(), material.harvestLevel}));
    }

    @Override
    public int getItemStackColor(ItemStack itemStack, int tintIndex) {
        IngotMaterial material = this.getPartMaterial(itemStack);
        return material.materialRGB;
    }

    @Override
    public boolean showsDurabilityBar(ItemStack itemStack) {
        return this.getPartDamage(itemStack) > 0;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack itemStack) {
        return (double)this.getPartDamage(itemStack) / ((double)this.getPartMaxDurability(itemStack) * 1.0);
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack itemStack) {
        return MathHelper.func_181758_c((float)((1.0f - (float)this.getDurabilityForDisplay(itemStack)) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

