/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.util.GTUtility;
import gregtech.common.MetaFluids;
import gregtech.common.blocks.MetaBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PotionFluids {
    private static final BiMap<ResourceLocation, Fluid> potionFluidMap = HashBiMap.create();

    public static Fluid getFluidForPotion(PotionType potion) {
        return (Fluid)potionFluidMap.get((Object)potion.getRegistryName());
    }

    public static PotionType getPotionForFluid(Fluid potionFluid) {
        ResourceLocation registryName = (ResourceLocation)potionFluidMap.inverse().get((Object)potionFluid);
        return registryName == null ? null : (PotionType)ForgeRegistries.POTION_TYPES.getValue(registryName);
    }

    public static void initPotionFluids() {
        MinecraftForge.EVENT_BUS.register((Object)new PotionFluids());
        for (ResourceLocation registryName : ForgeRegistries.POTION_TYPES.getKeys()) {
            Fluid potionFluid;
            if (registryName.func_110624_b().equals("minecraft") && registryName.func_110623_a().equals("empty")) continue;
            final PotionType potion = (PotionType)ForgeRegistries.POTION_TYPES.getValue(registryName);
            Preconditions.checkNotNull((Object)potion);
            if (potion != PotionTypes.field_185230_b) {
                String fluidName = String.format("potion.%s.%s", registryName.func_110624_b(), registryName.func_110623_a());
                potionFluid = new Fluid(fluidName, MetaFluids.AUTO_GENERATED_FLUID_TEXTURE, MetaFluids.AUTO_GENERATED_FLUID_TEXTURE){

                    public String getUnlocalizedName() {
                        return potion.func_185174_b("potion.effect.");
                    }
                };
                potionFluid.setColor(GTUtility.convertRGBtoOpaqueRGBA_MC(PotionUtils.func_185183_a((PotionType)potion)));
                FluidRegistry.registerFluid((Fluid)potionFluid);
                FluidRegistry.addBucketForFluid((Fluid)potionFluid);
                BlockPotionFluid fluidBlock = new BlockPotionFluid(potionFluid, potion);
                fluidBlock.setRegistryName("fluid." + fluidName);
                MetaBlocks.FLUID_BLOCKS.add((BlockFluidBase)fluidBlock);
            } else {
                potionFluid = FluidRegistry.WATER;
            }
            potionFluidMap.put((Object)potion.getRegistryName(), (Object)potionFluid);
        }
    }

    @SubscribeEvent
    public void onCapabilityAttach(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack itemStack = (ItemStack)event.getObject();
        if (itemStack.func_77973_b() instanceof ItemPotion) {
            ResourceLocation resourceLocation = new ResourceLocation("gregtech", "fluid_container");
            PotionItemFluidHandler fluidHandler = new PotionItemFluidHandler(itemStack);
            event.addCapability(resourceLocation, (ICapabilityProvider)fluidHandler);
        } else if (itemStack.func_77973_b() instanceof ItemGlassBottle) {
            ResourceLocation resourceLocation = new ResourceLocation("gregtech", "fluid_container");
            GlassBottleFluidHandler fluidHandler = new GlassBottleFluidHandler(itemStack);
            event.addCapability(resourceLocation, (ICapabilityProvider)fluidHandler);
        }
    }

    private static class BlockPotionFluid
    extends BlockFluidFinite {
        private final PotionType potionType;

        public BlockPotionFluid(Fluid fluid, PotionType potionType) {
            super(fluid, Material.field_151586_h);
            this.potionType = potionType;
        }

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            if (!(entityIn instanceof EntityLivingBase) || worldIn.func_82737_E() % 20L != 0L) {
                return;
            }
            EntityLivingBase entity = (EntityLivingBase)entityIn;
            for (PotionEffect potionEffect : this.potionType.func_185170_a()) {
                if (!potionEffect.func_188419_a().func_76403_b()) {
                    PotionEffect instantEffect = new PotionEffect(potionEffect.func_188419_a(), 60, potionEffect.func_76458_c(), true, true);
                    entity.func_70690_d(instantEffect);
                    continue;
                }
                potionEffect.func_188419_a().func_180793_a(null, null, entity, potionEffect.func_76458_c(), 1.0);
            }
        }
    }

    private static class GlassBottleFluidHandler
    extends FluidHandlerItemStackSimple {
        public GlassBottleFluidHandler(@Nonnull ItemStack container) {
            super(container, 144);
        }

        @Nullable
        public FluidStack getFluid() {
            return null;
        }

        protected void setFluid(FluidStack fluid) {
            PotionType potionType = PotionFluids.getPotionForFluid(fluid.getFluid());
            if (potionType != null && potionType != PotionTypes.field_185229_a) {
                GTUtility.setItem(this.container, new ItemStack((Item)Items.field_151068_bn));
                PotionUtils.func_185188_a((ItemStack)this.container, (PotionType)potionType);
            }
        }

        protected void setContainerToEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean canFillFluidType(FluidStack fluid) {
            PotionType potionType = PotionFluids.getPotionForFluid(fluid.getFluid());
            return potionType != null && potionType != PotionTypes.field_185229_a;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return false;
        }
    }

    private static class PotionItemFluidHandler
    extends FluidHandlerItemStackSimple {
        public PotionItemFluidHandler(@Nonnull ItemStack container) {
            super(container, 144);
        }

        public FluidStack getFluid() {
            PotionType potionType = PotionUtils.func_185191_c((ItemStack)this.container);
            if (potionType == PotionTypes.field_185229_a) {
                return null;
            }
            Fluid fluid = PotionFluids.getFluidForPotion(potionType);
            if (fluid == null) {
                return null;
            }
            return new FluidStack(fluid, this.capacity);
        }

        protected void setFluid(FluidStack fluid) {
            throw new UnsupportedOperationException();
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        protected void setContainerToEmpty() {
            GTUtility.setItem(this.container, new ItemStack(Items.field_151069_bo));
            this.container.func_77982_d(null);
        }
    }
}

