/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomFluidWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.items.MetaItems;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CoverPump
extends CoverBehavior
implements CoverWithUI,
ITickable {
    public static final Predicate<FluidStack> ALWAYS_TRUE = fluidStack -> true;
    public final int tier;
    public final int maxFluidTransferRate;
    protected int transferRate;
    protected PumpMode pumpMode;
    protected boolean isFilterInstalled;
    protected final ItemStackHandler filterTypeInventory;
    protected FluidStack[] fluidFilterSlots;
    protected int fluidLeftToTransferLastSecond;
    private CoverableFluidHandlerWrapper fluidHandlerWrapper;
    private Predicate<FluidStack> fluidFilter = this::checkInputFluid;

    public CoverPump(ICoverable coverHolder, EnumFacing attachedSide, int tier, int mbPerTick) {
        super(coverHolder, attachedSide);
        this.tier = tier;
        this.maxFluidTransferRate = mbPerTick;
        this.fluidLeftToTransferLastSecond = this.transferRate = mbPerTick;
        this.pumpMode = PumpMode.EXPORT;
        this.isFilterInstalled = false;
        this.fluidFilterSlots = new FluidStack[9];
        this.filterTypeInventory = new FilterTypeInventory();
    }

    protected void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
        this.coverHolder.markDirty();
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(MathHelper.func_76125_a((int)(this.transferRate + amount), (int)1, (int)this.maxFluidTransferRate));
    }

    public void setPumpMode(PumpMode pumpMode) {
        this.pumpMode = pumpMode;
        this.coverHolder.markDirty();
    }

    public void func_73660_a() {
        long timer = this.coverHolder.getTimer();
        if (this.fluidLeftToTransferLastSecond > 0) {
            this.fluidLeftToTransferLastSecond -= this.doTransferFluids(this.fluidLeftToTransferLastSecond);
        }
        if (timer % 20L == 0L) {
            this.fluidLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int doTransferFluids(int transferLimit) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        blockPos.func_189533_g((Vec3i)this.coverHolder.getPos()).func_189536_c(this.attachedSide);
        TileEntity tileEntity = this.coverHolder.getWorld().func_175625_s((BlockPos)blockPos);
        blockPos.func_185344_t();
        IFluidHandler fluidHandler = tileEntity == null ? null : (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide.func_176734_d());
        IFluidHandler myFluidHandler = (IFluidHandler)this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide);
        if (fluidHandler == null || myFluidHandler == null) {
            return 0;
        }
        return this.doTransferFluidsInternal(myFluidHandler, fluidHandler, transferLimit);
    }

    protected int doTransferFluidsInternal(IFluidHandler myFluidHandler, IFluidHandler fluidHandler, int transferLimit) {
        if (this.pumpMode == PumpMode.IMPORT) {
            return CoverPump.moveHandlerFluids(fluidHandler, myFluidHandler, transferLimit, this.fluidFilter);
        }
        if (this.pumpMode == PumpMode.EXPORT) {
            return CoverPump.moveHandlerFluids(myFluidHandler, fluidHandler, transferLimit, this.fluidFilter);
        }
        return 0;
    }

    public static int moveHandlerFluids(IFluidHandler sourceHandler, IFluidHandler destHandler, int transferLimit, Predicate<FluidStack> fluidFilter) {
        int fluidLeftToTransfer = transferLimit;
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            int canInsertAmount;
            FluidStack currentFluid = tankProperties.getContents();
            if (currentFluid == null || currentFluid.amount == 0 || !fluidFilter.test(currentFluid)) continue;
            currentFluid.amount = fluidLeftToTransfer;
            FluidStack fluidStack = sourceHandler.drain(currentFluid, false);
            if (fluidStack == null || fluidStack.amount == 0 || (canInsertAmount = destHandler.fill(fluidStack, false)) <= 0 || (fluidStack = sourceHandler.drain(canInsertAmount, true)) == null || fluidStack.amount <= 0) continue;
            destHandler.fill(fluidStack, true);
            if ((fluidLeftToTransfer -= fluidStack.amount) == 0) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }

    protected boolean checkInputFluid(FluidStack fluidStack) {
        if (!this.isFilterInstalled) {
            return true;
        }
        for (FluidStack filterStack : this.fluidFilterSlots) {
            if (filterStack == null || !filterStack.isFluidEqual(fluidStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, "cover.pump.title", GTValues.VN[this.tier]));
        primaryGroup.addWidget(new ClickButtonWidget(10, 20, 20, 20, "-10", data -> this.adjustTransferRate(data.isShiftClick ? -100 : -10)));
        primaryGroup.addWidget(new ClickButtonWidget(146, 20, 20, 20, "+10", data -> this.adjustTransferRate(data.isShiftClick ? 100 : 10)));
        primaryGroup.addWidget(new ClickButtonWidget(30, 20, 20, 20, "-1", data -> this.adjustTransferRate(data.isShiftClick ? -5 : -1)));
        primaryGroup.addWidget(new ClickButtonWidget(126, 20, 20, 20, "+1", data -> this.adjustTransferRate(data.isShiftClick ? 5 : 1)));
        primaryGroup.addWidget(new ImageWidget(50, 20, 76, 20, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new SimpleTextWidget(88, 30, "cover.pump.transfer_rate", 0xFFFFFF, () -> Integer.toString(this.transferRate)));
        primaryGroup.addWidget(new CycleButtonWidget(10, 45, 75, 20, GTUtility.mapToString(CoverConveyor.ConveyorMode.values(), it -> it.localeName), () -> this.pumpMode.ordinal(), newMode -> this.setPumpMode(PumpMode.values()[newMode])));
        primaryGroup.addWidget(new LabelWidget(10, 70, "cover.pump.fluid_filter.title", new Object[0]));
        primaryGroup.addWidget(new SlotWidget((IItemHandlerModifiable)this.filterTypeInventory, 0, 10, 85).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY));
        ServerWidgetGroup fluidFilterGroup = new ServerWidgetGroup(() -> this.isFilterInstalled);
        for (int i = 0; i < 9; ++i) {
            int slotIndex = i;
            fluidFilterGroup.addWidget(new PhantomFluidWidget(10 + 18 * (i % 3), 106 + 18 * (i / 3), 18, 18, () -> this.fluidFilterSlots[slotIndex], newFluid -> {
                this.fluidFilterSlots[slotIndex] = newFluid;
            }).setBackgroundTexture(GuiTextures.SLOT));
        }
        return ModularUI.builder(GuiTextures.BACKGROUND_EXTENDED, 176, 198).widget(primaryGroup).widget(fluidFilterGroup).bindPlayerHotbar(player.field_71071_by, GuiTextures.SLOT, 8, 170).build(this, player);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public void onRemoved() {
        NonNullList drops = NonNullList.func_191196_a();
        MetaTileEntity.clearInventory((NonNullList<ItemStack>)drops, (IItemHandlerModifiable)this.filterTypeInventory);
        for (ItemStack itemStack : drops) {
            Block.func_180635_a((World)this.coverHolder.getWorld(), (BlockPos)this.coverHolder.getPos(), (ItemStack)itemStack);
        }
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox) {
        Textures.PUMP_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler delegate = (IFluidHandler)defaultValue;
            if (this.fluidHandlerWrapper == null || this.fluidHandlerWrapper.delegate != delegate) {
                this.fluidHandlerWrapper = new CoverableFluidHandlerWrapper(delegate);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandlerWrapper);
        }
        return defaultValue;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("PumpMode", this.pumpMode.ordinal());
        tagCompound.func_74782_a("FilterTypeInventory", (NBTBase)this.filterTypeInventory.serializeNBT());
        NBTTagList filterSlots = new NBTTagList();
        for (int i = 0; i < this.fluidFilterSlots.length; ++i) {
            FluidStack fluidStack = this.fluidFilterSlots[i];
            if (fluidStack == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            fluidStack.writeToNBT(stackTag);
            stackTag.func_74768_a("Slot", i);
            filterSlots.func_74742_a((NBTBase)stackTag);
        }
        tagCompound.func_74782_a("FluidFilter", (NBTBase)filterSlots);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.pumpMode = PumpMode.values()[tagCompound.func_74762_e("PumpMode")];
        this.filterTypeInventory.deserializeNBT(tagCompound.func_74775_l("FilterTypeInventory"));
        NBTTagList filterSlots = tagCompound.func_150295_c("FluidFilter", 10);
        for (NBTBase nbtBase : filterSlots) {
            FluidStack fluidStack;
            NBTTagCompound stackTag = (NBTTagCompound)nbtBase;
            this.fluidFilterSlots[stackTag.func_74762_e((String)"Slot")] = fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag);
        }
    }

    private class CoverableFluidHandlerWrapper
    extends FluidHandlerDelegate {
        public CoverableFluidHandlerWrapper(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (CoverPump.this.pumpMode == PumpMode.EXPORT) {
                return 0;
            }
            if (CoverPump.this.isFilterInstalled && !CoverPump.this.checkInputFluid(resource)) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT) {
                return null;
            }
            if (CoverPump.this.isFilterInstalled && !CoverPump.this.checkInputFluid(resource)) {
                return null;
            }
            return super.drain(resource, doDrain);
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT) {
                return null;
            }
            FluidStack result = super.drain(maxDrain, false);
            if (CoverPump.this.isFilterInstalled && !CoverPump.this.checkInputFluid(result)) {
                return null;
            }
            if (doDrain) {
                super.drain(maxDrain, true);
            }
            return result;
        }
    }

    public static enum PumpMode {
        IMPORT("cover.pump.mode.import"),
        EXPORT("cover.pump.mode.export");

        public final String localeName;

        private PumpMode(String localeName) {
            this.localeName = localeName;
        }
    }

    private class FilterTypeInventory
    extends ItemStackHandler {
        private FilterTypeInventory() {
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isFilterStack(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onLoad() {
            this.onContentsChanged(0);
        }

        protected void onContentsChanged(int slot) {
            ItemStack itemStack = this.getStackInSlot(slot);
            CoverPump.this.isFilterInstalled = this.isFilterStack(itemStack);
        }

        private boolean isFilterStack(ItemStack itemStack) {
            return !itemStack.func_190926_b() && MetaItems.FLUID_FILTER.isItemEqual(itemStack);
        }
    }
}

