/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomFluidWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.FluidFilterMode;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CoverFluidFilter
extends CoverBehavior
implements CoverWithUI {
    protected FluidStack[] fluidFilterSlots;
    protected FluidFilterMode filterMode = FluidFilterMode.FILTER_FILL;
    protected FilteredFluidHandler fluidHandler;

    public CoverFluidFilter(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
        this.fluidFilterSlots = new FluidStack[9];
    }

    protected void setFilterMode(FluidFilterMode filterMode) {
        this.filterMode = filterMode;
        this.coverHolder.markDirty();
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!playerIn.field_70170_p.field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup fluidFilterGroup = new WidgetGroup();
        fluidFilterGroup.addWidget(new LabelWidget(10, 5, "cover.fluid_filter.title", new Object[0]));
        fluidFilterGroup.addWidget(new CycleButtonWidget(10, 20, 110, 20, GTUtility.mapToString(FluidFilterMode.values(), it -> it.localeName), () -> this.filterMode.ordinal(), newMode -> this.setFilterMode(FluidFilterMode.values()[newMode])));
        for (int i = 0; i < 9; ++i) {
            int index = i;
            fluidFilterGroup.addWidget(new PhantomFluidWidget(10 + 18 * (i % 3), 46 + 18 * (i / 3), 18, 18, () -> this.fluidFilterSlots[index], newFluid -> {
                this.fluidFilterSlots[index] = newFluid;
            }).setBackgroundTexture(GuiTextures.SLOT));
        }
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 130).widget(fluidFilterGroup).bindPlayerHotbar(player.field_71071_by, GuiTextures.SLOT, 8, 107).build(this, player);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox) {
        Textures.FLUID_FILTER_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler delegate = (IFluidHandler)defaultValue;
            if (this.fluidHandler == null || this.fluidHandler.delegate != delegate) {
                this.fluidHandler = new FilteredFluidHandlerImpl(delegate);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return defaultValue;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("FilterMode", this.filterMode.ordinal());
        NBTTagList filterSlots = new NBTTagList();
        for (int i = 0; i < this.fluidFilterSlots.length; ++i) {
            FluidStack fluidStack = this.fluidFilterSlots[i];
            if (fluidStack == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            fluidStack.writeToNBT(stackTag);
            stackTag.func_74768_a("Slot", i);
            filterSlots.func_74742_a((NBTBase)stackTag);
        }
        tagCompound.func_74782_a("FluidFilter", (NBTBase)filterSlots);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.filterMode = FluidFilterMode.values()[tagCompound.func_74762_e("FilterMode")];
        NBTTagList filterSlots = tagCompound.func_150295_c("FluidFilter", 10);
        for (NBTBase nbtBase : filterSlots) {
            FluidStack fluidStack;
            NBTTagCompound stackTag = (NBTTagCompound)nbtBase;
            this.fluidFilterSlots[stackTag.func_74762_e((String)"Slot")] = fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag);
        }
    }

    public static boolean checkInputFluid(FluidStack[] fluidFilterSlots, FluidStack fluidStack) {
        for (FluidStack filterStack : fluidFilterSlots) {
            if (filterStack == null || !filterStack.isFluidEqual(fluidStack)) continue;
            return true;
        }
        return false;
    }

    private class FilteredFluidHandlerImpl
    extends FilteredFluidHandler {
        public FilteredFluidHandlerImpl(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public FluidFilterMode getFilterMode() {
            return CoverFluidFilter.this.filterMode;
        }

        @Override
        public FluidStack[] getFilterSlots() {
            return CoverFluidFilter.this.fluidFilterSlots;
        }
    }

    public static abstract class FilteredFluidHandler
    extends FluidHandlerDelegate {
        public FilteredFluidHandler(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            FluidFilterMode filterMode = this.getFilterMode();
            if (filterMode == FluidFilterMode.FILTER_DRAIN) {
                return 0;
            }
            if (!CoverFluidFilter.checkInputFluid(this.getFilterSlots(), resource)) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidFilterMode filterMode = this.getFilterMode();
            if (filterMode == FluidFilterMode.FILTER_DRAIN) {
                return null;
            }
            if (!CoverFluidFilter.checkInputFluid(this.getFilterSlots(), resource)) {
                return null;
            }
            return super.drain(resource, doDrain);
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidFilterMode filterMode = this.getFilterMode();
            if (filterMode == FluidFilterMode.FILTER_FILL) {
                return null;
            }
            FluidStack result = super.drain(maxDrain, false);
            if (!CoverFluidFilter.checkInputFluid(this.getFilterSlots(), result)) {
                return null;
            }
            if (doDrain) {
                super.drain(maxDrain, true);
            }
            return result;
        }

        public abstract FluidFilterMode getFilterMode();

        public abstract FluidStack[] getFilterSlots();
    }
}

