/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.surfacerock;

import codechicken.lib.vec.Cuboid6;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.XSTR;
import gregtech.common.blocks.properties.PropertyMaterial;
import gregtech.common.render.StoneRenderer;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSurfaceRock
extends Block {
    public final PropertyMaterial materialProperty;

    public BlockSurfaceRock(gregtech.api.unification.material.type.Material[] allowedValues) {
        super(Material.field_151576_e);
        this.materialProperty = PropertyMaterial.create("material", allowedValues);
        this.func_149711_c(1.0f);
        this.func_149752_b(0.3f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("surface_rock");
        this.initBlockState();
    }

    protected void initBlockState() {
        BlockStateContainer stateContainer;
        this.field_176227_L = stateContainer = this.func_180661_e();
        this.func_180632_j(stateContainer.func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        if (this.materialProperty == null) {
            return new BlockStateContainer((Block)this, new IProperty[0]);
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.materialProperty});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.materialProperty, (Comparable)this.materialProperty.getAllowedValues().get(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.materialProperty.getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.materialProperty));
    }

    public static Cuboid6 getShapeFromBlockPos(BlockPos blockPos) {
        int startX;
        XSTR random = new XSTR(Arrays.hashCode(new int[]{blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), 135}));
        int size = 4 + random.nextInt(2);
        boolean invertStart = random.nextBoolean();
        boolean moveStart = random.nextBoolean();
        int n = invertStart ? 8 : (startX = 6 - (moveStart ? size : 0));
        int startZ = invertStart ? 6 : 8 - (moveStart ? 0 : size);
        return new Cuboid6((double)startX / 16.0, 0.0, (double)startZ / 16.0, (double)(startX + size) / 16.0, (double)size / 16.0, (double)(startZ + size) / 16.0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockSurfaceRock.getShapeFromBlockPos(pos).aabb();
    }

    private ItemStack getDropStack(IBlockState blockState, int amount) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)blockState.func_177229_b((IProperty)this.materialProperty);
        if (material instanceof IngotMaterial && ((IngotMaterial)material).blastFurnaceTemperature == 0) {
            return OreDictUnifier.get(OrePrefix.nugget, material, amount);
        }
        return OreDictUnifier.get(OrePrefix.dustTiny, material, amount);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDropStack(state, 1);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int amount = 1 + rand.nextInt(fortune == 0 ? 1 : fortune);
        drops.add((Object)this.getDropStack(state, amount));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return StoneRenderer.BLOCK_RENDER_TYPE;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (fromPos.func_177984_a().equals((Object)pos) && worldIn.func_180495_p(fromPos).func_193401_d((IBlockAccess)worldIn, fromPos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

