/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;

public class StoneBlock<T extends Enum<T>>
extends Block {
    private static PropertyEnum<ChiselingVariant> CHISELING_VARIANT = PropertyEnum.func_177709_a((String)"chiseling", ChiselingVariant.class);
    private PropertyEnum<T> VARIANT;
    private T[] VALUES;

    public StoneBlock(Material materialIn) {
        super(materialIn);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (T variant : this.VALUES) {
            for (ChiselingVariant chiselingVariant : ChiselingVariant.values()) {
                list.add((Object)this.getItemVariant(variant, chiselingVariant));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public T[] getVariantValues() {
        return (Enum[])Arrays.copyOf(this.VALUES, this.VALUES.length);
    }

    public T getVariant(IBlockState blockState) {
        return (T)((Enum)((Object)blockState.func_177229_b(this.VARIANT)));
    }

    public ChiselingVariant getChiselingVariant(IBlockState blockState) {
        return (ChiselingVariant)((Object)blockState.func_177229_b(CHISELING_VARIANT));
    }

    public IBlockState withVariant(T variant, ChiselingVariant chiselingVariant) {
        return this.func_176223_P().func_177226_a(this.VARIANT, variant).func_177226_a(CHISELING_VARIANT, (Comparable)((Object)chiselingVariant));
    }

    public ItemStack getItemVariant(T variant, ChiselingVariant chiselingVariant) {
        return this.getItemVariant(variant, chiselingVariant, 1);
    }

    public ItemStack getItemVariant(T variant, ChiselingVariant chiselingVariant, int amount) {
        return new ItemStack((Block)this, amount, chiselingVariant.ordinal() * 4 + ((Enum)variant).ordinal());
    }

    protected BlockStateContainer func_180661_e() {
        Class enumClass = GTUtility.getActualTypeParameter(((Object)((Object)this)).getClass(), StoneBlock.class, 0);
        this.VARIANT = PropertyEnum.func_177709_a((String)"variant", enumClass);
        this.VALUES = (Enum[])enumClass.getEnumConstants();
        return new BlockStateContainer((Block)this, new IProperty[]{this.VARIANT, CHISELING_VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CHISELING_VARIANT, (Comparable)((Object)ChiselingVariant.values()[meta / 4])).func_177226_a(this.VARIANT, this.VALUES[meta % 4]);
    }

    public int func_176201_c(IBlockState state) {
        return ((ChiselingVariant)((Object)state.func_177229_b(CHISELING_VARIANT))).ordinal() * 4 + ((Enum)((Object)state.func_177229_b(this.VARIANT))).ordinal();
    }

    public static enum ChiselingVariant implements IStringSerializable
    {
        NORMAL("normal"),
        CRACKED("cracked"),
        MOSSY("mossy"),
        CHISELED("chiseled");

        private final String name;

        private ChiselingVariant(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

