/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import net.minecraft.world.World;

public class PerTickLongCounter {
    private final long defaultValue;
    private long lastUpdatedWorldTime;
    private long lastValue;
    private long currentValue;

    public PerTickLongCounter(long defaultValue) {
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.lastValue = defaultValue;
    }

    private void checkValueState(World world) {
        long currentWorldTime = world.func_82737_E();
        if (currentWorldTime != this.lastUpdatedWorldTime) {
            this.lastValue = currentWorldTime == this.lastUpdatedWorldTime + 1L ? this.currentValue : this.defaultValue;
            this.lastUpdatedWorldTime = currentWorldTime;
            this.currentValue = this.defaultValue;
        }
    }

    public long get(World world) {
        this.checkValueState(world);
        return this.currentValue;
    }

    public long getLast(World world) {
        this.checkValueState(world);
        return this.lastValue;
    }

    public void increment(World world, long value) {
        this.checkValueState(world);
        this.currentValue += value;
    }

    public void set(World world, long value) {
        this.checkValueState(world);
        this.currentValue = value;
    }
}

