/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.render.particle.DigIconParticle;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ParticleHandlerUtil {
    public static void addBlockRunningEffects(World worldObj, Entity entity, TextureAtlasSprite atlasSprite) {
        Random rand = new Random();
        double posX = entity.field_70165_t + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N;
        double posY = entity.func_174813_aQ().field_72338_b + 0.1;
        double posZ = entity.field_70161_v + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N;
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        manager.func_78873_a((Particle)new DigIconParticle(worldObj, posX, posY, posZ, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, atlasSprite));
    }

    public static void addBlockLandingEffects(World worldObj, Vector3 entityPos, TextureAtlasSprite atlasSprite, ParticleManager manager, int numParticles) {
        Vector3 start = entityPos.copy();
        Vector3 end = start.copy().add(Vector3.down.copy().multiply(4.0));
        RayTraceResult traceResult = worldObj.func_147447_a(start.vec3(), end.vec3(), true, false, true);
        double speed = 0.15;
        Random randy = new Random();
        if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK && numParticles != 0) {
            for (int i = 0; i < numParticles; ++i) {
                double mX = randy.nextGaussian() * speed;
                double mY = randy.nextGaussian() * speed;
                double mZ = randy.nextGaussian() * speed;
                manager.func_78873_a((Particle)DigIconParticle.newLandingParticle((World)worldObj, (double)entityPos.x, (double)entityPos.y, (double)entityPos.z, (double)mX, (double)mY, (double)mZ, (TextureAtlasSprite)atlasSprite));
            }
        }
    }

    public static void addBlockDestroyEffects(World worldObj, CuboidRayTraceResult result, TextureAtlasSprite atlasSprite, ParticleManager manager) {
        CustomParticleHandler.addBlockDestroyEffects((World)worldObj, (Cuboid6)result.cuboid6, (List)Lists.newArrayList((Object[])new TextureAtlasSprite[]{atlasSprite}), (ParticleManager)manager);
    }

    public static void addBlockDestroyEffects(IBlockState blockState, World worldObj, BlockPos blockPos, TextureAtlasSprite atlasSprite, ParticleManager manager) {
        Cuboid6 cuboid6 = new Cuboid6(blockState.func_185900_c((IBlockAccess)worldObj, blockPos)).add(blockPos);
        CustomParticleHandler.addBlockDestroyEffects((World)worldObj, (Cuboid6)cuboid6, (List)Lists.newArrayList((Object[])new TextureAtlasSprite[]{atlasSprite}), (ParticleManager)manager);
    }

    public static void addHitEffects(World worldObj, CuboidRayTraceResult result, TextureAtlasSprite atlasSprite, ParticleManager manager) {
        CustomParticleHandler.addBlockHitEffects((World)worldObj, (Cuboid6)result.cuboid6, (EnumFacing)result.field_178784_b, (TextureAtlasSprite)atlasSprite, (ParticleManager)manager);
    }

    public static void addHitEffects(IBlockState blockState, World worldObj, RayTraceResult target, TextureAtlasSprite atlasSprite, ParticleManager manager) {
        Cuboid6 cuboid6 = ParticleHandlerUtil.getBoundingBox(blockState, worldObj, target);
        CustomParticleHandler.addBlockHitEffects((World)worldObj, (Cuboid6)cuboid6, (EnumFacing)target.field_178784_b, (TextureAtlasSprite)atlasSprite, (ParticleManager)manager);
    }

    private static Cuboid6 getBoundingBox(IBlockState blockState, World world, RayTraceResult target) {
        BlockPos blockPos = target.func_178782_a();
        if (target instanceof CuboidRayTraceResult) {
            return ((CuboidRayTraceResult)target).cuboid6.copy().add(blockPos);
        }
        return new Cuboid6(blockState.func_185900_c((IBlockAccess)world, blockPos)).add(blockPos);
    }
}

