/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.ore;

import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneTypes;
import gregtech.api.util.GTControlledRegistry;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class StoneType
implements Comparable<StoneType> {
    public static final int AFFECTED_BY_GRAVITY = 1;
    public static final int UNBREAKABLE = 2;
    public final String name;
    public final String harvestTool;
    public final ResourceLocation backgroundSideTexture;
    public final ResourceLocation backgroundTopTexture;
    public final OrePrefix processingPrefix;
    public final DustMaterial stoneMaterial;
    public final Supplier<IBlockState> stone;
    public final SoundType soundType;
    private final com.google.common.base.Predicate<IBlockState> predicate;
    public final boolean unbreakable;
    public final boolean affectedByGravity;
    public static final GTControlledRegistry<String, StoneType> STONE_TYPE_REGISTRY = new GTControlledRegistry(128);

    public StoneType(int id, String name, ResourceLocation backgroundSideTexture, ResourceLocation backgroundTopTexture, SoundType soundType, OrePrefix processingPrefix, DustMaterial stoneMaterial, String harvestTool, int flags, Supplier<IBlockState> stone, Predicate<IBlockState> predicate) {
        this.name = name;
        this.backgroundSideTexture = backgroundSideTexture;
        this.backgroundTopTexture = backgroundTopTexture;
        this.soundType = soundType;
        this.processingPrefix = processingPrefix;
        this.stoneMaterial = stoneMaterial;
        this.harvestTool = harvestTool;
        this.unbreakable = (flags & 2) > 0;
        this.affectedByGravity = (flags & 1) > 0;
        this.stone = stone;
        this.predicate = predicate::test;
        STONE_TYPE_REGISTRY.register(id, name, this);
    }

    public StoneType(int id, String name, ResourceLocation backgroundTexture, SoundType soundType, OrePrefix processingPrefix, DustMaterial stoneMaterial, String harvestTool, int flags, Supplier<IBlockState> stone, Predicate<IBlockState> predicate) {
        this(id, name, backgroundTexture, backgroundTexture, soundType, processingPrefix, stoneMaterial, harvestTool, flags, stone, predicate);
    }

    @Override
    public int compareTo(StoneType stoneType) {
        return STONE_TYPE_REGISTRY.getIDForObject(this) - STONE_TYPE_REGISTRY.getIDForObject(stoneType);
    }

    public static void init() {
        StoneTypes.STONE.name.getBytes();
    }

    public static StoneType computeStoneType(IBlockState blockState, IBlockAccess world, BlockPos blockPos) {
        Iterator<StoneType> iterator = STONE_TYPE_REGISTRY.iterator();
        while (iterator.hasNext()) {
            StoneType stoneType = iterator.next();
            if (!blockState.func_177230_c().isReplaceableOreGen(blockState, world, blockPos, stoneType.predicate)) continue;
            return stoneType;
        }
        return null;
    }
}

