/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import gregtech.api.unification.material.MaterialIconSet;
import net.minecraft.util.ResourceLocation;

public enum MaterialIconType {
    dustTiny,
    dustSmall,
    dust,
    dustImpure,
    dustPure,
    crushed,
    crushedPurified,
    crushedCentrifuged,
    gem,
    nugget,
    ingot,
    ingotHot,
    ingotDouble,
    ingotTriple,
    ingotQuadruple,
    ingotQuintuple,
    plate,
    plateDouble,
    plateTriple,
    plateQuadruple,
    plateQuintuple,
    plateDense,
    stick,
    lens,
    round,
    bolt,
    screw,
    ring,
    cell,
    cellPlasma,
    toolHeadSword,
    toolHeadPickaxe,
    toolHeadShovel,
    toolHeadAxe,
    toolHeadHoe,
    toolHeadHammer,
    toolHeadFile,
    toolHeadSaw,
    toolHeadBuzzSaw,
    toolHeadDrill,
    toolHeadChainsaw,
    toolHeadSense,
    toolHeadPlow,
    toolHeadArrow,
    toolHeadScrewdriver,
    toolHeadBuzSaw,
    toolHeadSoldering,
    toolHeadWrench,
    toolHeadUniversalSpade,
    wireFine,
    gearSmall,
    rotor,
    stickLong,
    springSmall,
    spring,
    arrow,
    gemChipped,
    gemFlawed,
    gemFlawless,
    gemExquisite,
    gear,
    foil,
    crateGtDust,
    crateGtIngot,
    crateGtGem,
    crateGtPlate,
    turbineBlade,
    handleMallet,
    toolHeadMallet,
    block,
    foilBlock,
    wire,
    ore,
    frameGt,
    frameSide,
    frameTop,
    pipeSide,
    pipeTiny,
    pipeSmall,
    pipeMedium,
    pipeLarge,
    pipeHuge;

    public static final ImmutableMap<String, MaterialIconType> values;

    public ResourceLocation getBlockPath(MaterialIconSet materialIconSet) {
        String iconSet = materialIconSet.name().toLowerCase();
        String iconType = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        return new ResourceLocation("gregtech", "blocks/material_sets/" + iconSet + "/" + iconType);
    }

    public ResourceLocation getItemModelPath(MaterialIconSet materialIconSet) {
        String iconSet = materialIconSet.name().toLowerCase();
        String iconType = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        return new ResourceLocation("gregtech", "material_sets/" + iconSet + "/" + iconType);
    }

    public ResourceLocation getItemOverlayPath(MaterialIconSet materialIconSet) {
        String iconSet = materialIconSet.name().toLowerCase();
        String iconType = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        return new ResourceLocation("gregtech", "material_sets/" + iconSet + "/" + iconType + "_overlay");
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MaterialIconType value : MaterialIconType.values()) {
            builder.put((Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, value.name()), (Object)value);
        }
        values = builder.build();
    }
}

