/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SimpleSidedCubeRenderer
implements ICubeRenderer,
TextureUtils.IIconRegister {
    protected final String basePath;
    @SideOnly(value=Side.CLIENT)
    protected Map<RenderSide, TextureAtlasSprite> sprites;

    public SimpleSidedCubeRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sprites = new HashMap<RenderSide, TextureAtlasSprite>();
        for (RenderSide overlayFace : RenderSide.values()) {
            String faceName = overlayFace.name().toLowerCase();
            ResourceLocation resourceLocation = new ResourceLocation("gregtech", String.format("blocks/%s/%s", this.basePath, faceName));
            this.sprites.put(overlayFace, textureMap.func_174942_a(resourceLocation));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSpriteOnSide(RenderSide renderSide) {
        return this.sprites.get((Object)renderSide);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        return this.getSpriteOnSide(RenderSide.TOP);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds) {
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            RenderSide overlayFace = RenderSide.bySide(renderSide);
            TextureAtlasSprite renderSprite = this.sprites.get((Object)overlayFace);
            Textures.renderFace(renderState, translation, pipeline, renderSide, bounds, renderSprite);
        }
    }

    public static enum RenderSide {
        TOP,
        BOTTOM,
        SIDE;


        public static RenderSide bySide(EnumFacing side) {
            if (side == EnumFacing.UP) {
                return TOP;
            }
            if (side == EnumFacing.DOWN) {
                return BOTTOM;
            }
            return SIDE;
        }
    }
}

