/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tile;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.metatileentity.SyncedTileEntityBase;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.type.Material;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileEntityPipeBase<PipeType extends Enum<PipeType>, NodeDataType>
extends SyncedTileEntityBase
implements IPipeTile<PipeType, NodeDataType> {
    protected int blockedConnections = 0;
    protected int insulationColor = 0x777777;
    protected final PipeCoverableImplementation coverableImplementation = new PipeCoverableImplementation(this);
    private NodeDataType cachedNodeData;
    private Material pipeMaterial;
    private PipeType pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[0];
    private boolean isBeingConverted;

    public boolean isBeingConverted() {
        return this.isBeingConverted;
    }

    public void setBeingConverted(boolean beingConverted) {
        this.isBeingConverted = beingConverted;
    }

    @Override
    public void setPipeType(PipeType pipeType) {
        this.pipeType = pipeType;
    }

    @Override
    public void setPipeMaterial(Material pipeMaterial) {
        this.pipeMaterial = pipeMaterial;
    }

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> tileEntity) {
        this.pipeType = tileEntity.getPipeType();
        this.pipeMaterial = tileEntity.getPipeMaterial();
        this.blockedConnections = tileEntity.getBlockedConnections();
        this.insulationColor = tileEntity.getInsulationColor();
        tileEntity.getCoverableImplementation().transferDataTo(this.coverableImplementation);
    }

    public abstract Class<PipeType> getPipeTypeClass();

    @Override
    public abstract boolean supportsTicking();

    @Override
    public World getPipeWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPipePos() {
        return this.func_174877_v();
    }

    @Override
    public PipeCoverableImplementation getCoverableImplementation() {
        return this.coverableImplementation;
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return true;
    }

    @Override
    public IPipeTile<PipeType, NodeDataType> setSupportsTicking() {
        if (this.supportsTicking()) {
            return this;
        }
        TileEntityPipeBase<PipeType, NodeDataType> newTile = this.getPipeBlock().createNewTileEntity(true);
        newTile.transferDataFrom(this);
        this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)newTile);
        return newTile;
    }

    @Override
    public BlockPipe<PipeType, NodeDataType, ?> getPipeBlock() {
        return (BlockPipe)this.getBlockState().func_177230_c();
    }

    @Override
    public int getBlockedConnections() {
        return this.blockedConnections;
    }

    @Override
    public int getInsulationColor() {
        return this.insulationColor;
    }

    @Override
    public void setInsulationColor(int insulationColor) {
        this.insulationColor = insulationColor;
        if (!this.func_145831_w().field_72995_K) {
            ((WorldPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.func_145831_w()))).updateMark(this.func_174877_v(), this.getCableMark());
            this.writeCustomData(-1, buffer -> buffer.writeInt(insulationColor));
            this.func_70296_d();
        }
    }

    public void setConnectionBlocked(EnumFacing side, boolean blocked) {
        this.blockedConnections = blocked ? (this.blockedConnections |= 1 << side.func_176745_a()) : (this.blockedConnections &= ~(1 << side.func_176745_a()));
        if (!this.func_145831_w().field_72995_K) {
            ((WorldPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.func_145831_w()))).updateBlockedConnections(this.func_174877_v(), side, blocked);
            this.writeCustomData(-2, buffer -> buffer.writeInt(this.blockedConnections));
            this.func_70296_d();
        }
    }

    @Override
    public PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public Material getPipeMaterial() {
        return this.pipeMaterial;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    private int getCableMark() {
        return this.insulationColor == 0x777777 ? 0 : this.insulationColor;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == GregtechCapabilities.CAPABILITY_COVERABLE) {
            return (T)GregtechCapabilities.CAPABILITY_COVERABLE.cast((Object)this.getCoverableImplementation());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public final <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        boolean isCoverable = capability == GregtechCapabilities.CAPABILITY_COVERABLE;
        CoverBehavior coverBehavior = facing == null ? null : this.coverableImplementation.getCoverAtSide(facing);
        T defaultValue = this.getCapabilityInternal(capability, facing);
        if (coverBehavior != null && !isCoverable) {
            return coverBehavior.getCapability(capability, defaultValue);
        }
        return defaultValue;
    }

    public final boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("PipeType", ((Enum)this.pipeType).ordinal());
        compound.func_74778_a("PipeMaterial", this.pipeMaterial.toString());
        compound.func_74768_a("BlockedConnections", this.blockedConnections);
        compound.func_74768_a("InsulationColor", this.insulationColor);
        this.coverableImplementation.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[compound.func_74762_e("PipeType")];
        this.pipeMaterial = (Material)Material.MATERIAL_REGISTRY.func_82594_a(compound.func_74779_i("PipeMaterial"));
        this.blockedConnections = compound.func_74762_e("BlockedConnections");
        this.insulationColor = compound.func_74762_e("InsulationColor");
        this.coverableImplementation.readFromNBT(compound);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        buf.func_150787_b(((Enum)this.pipeType).ordinal());
        buf.func_150787_b(Material.MATERIAL_REGISTRY.getIDForObject(this.pipeMaterial));
        buf.func_150787_b(this.blockedConnections);
        buf.writeInt(this.insulationColor);
        this.coverableImplementation.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[buf.func_150792_a()];
        this.pipeMaterial = Material.MATERIAL_REGISTRY.getObjectById(buf.func_150792_a());
        this.blockedConnections = buf.func_150792_a();
        this.insulationColor = buf.readInt();
        this.coverableImplementation.readInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        if (discriminator == -1) {
            this.insulationColor = buf.readInt();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -2) {
            this.blockedConnections = buf.func_150792_a();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -3) {
            this.coverableImplementation.readCustomData(buf.func_150792_a(), buf);
        }
    }

    @Override
    public void writeCoverCustomData(int id, Consumer<PacketBuffer> writer) {
        this.writeCustomData(-3, buffer -> {
            buffer.func_150787_b(id);
            writer.accept((PacketBuffer)buffer);
        });
    }

    @Override
    public void scheduleChunkForRenderUpdate() {
        BlockPos pos = this.func_174877_v();
        this.func_145831_w().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    @Override
    public void notifyBlockUpdate() {
        this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        this.getPipeBlock().updateActiveNodeStatus(this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public void markAsDirty() {
        this.func_70296_d();
    }

    @Override
    public boolean isValidTile() {
        return !this.func_145837_r();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

