/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.SizeProvider;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.DynamicLabelWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public final class ModularUI
implements SizeProvider {
    public final ImmutableBiMap<Integer, Widget> guiWidgets;
    public final TextureArea backgroundPath;
    private int screenWidth;
    private int screenHeight;
    private final int width;
    private final int height;
    private final ImmutableList<Runnable> uiOpenCallback;
    private final ImmutableList<Runnable> uiCloseCallback;
    public boolean isJEIHandled;
    public final IUIHolder holder;
    public final EntityPlayer entityPlayer;

    public ModularUI(ImmutableBiMap<Integer, Widget> guiWidgets, ImmutableList<Runnable> openListeners, ImmutableList<Runnable> closeListeners, TextureArea backgroundPath, int width, int height, IUIHolder holder, EntityPlayer entityPlayer) {
        this.guiWidgets = guiWidgets;
        this.uiOpenCallback = openListeners;
        this.uiCloseCallback = closeListeners;
        this.backgroundPath = backgroundPath;
        this.width = width;
        this.height = height;
        this.holder = holder;
        this.entityPlayer = entityPlayer;
    }

    public void updateScreenSize(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void initWidgets() {
        this.guiWidgets.values().forEach(widget -> {
            widget.setGui(this);
            widget.setSizes(this);
            widget.initWidget();
        });
    }

    public void triggerOpenListeners() {
        this.uiOpenCallback.forEach(Runnable::run);
    }

    public void triggerCloseListeners() {
        this.uiCloseCallback.forEach(Runnable::run);
    }

    public static Builder defaultBuilder() {
        return new Builder(GuiTextures.BACKGROUND, 176, 166);
    }

    public static Builder borderedBuilder() {
        return new Builder(GuiTextures.BORDERED_BACKGROUND, 195, 136);
    }

    public static Builder extendedBuilder() {
        return new Builder(GuiTextures.BACKGROUND_EXTENDED, 176, 216);
    }

    public static Builder builder(TextureArea background, int width, int height) {
        return new Builder(background, width, height);
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static class Builder {
        private ImmutableBiMap.Builder<Integer, Widget> widgets = ImmutableBiMap.builder();
        private ImmutableList.Builder<Runnable> openListeners = ImmutableList.builder();
        private ImmutableList.Builder<Runnable> closeListeners = ImmutableList.builder();
        private TextureArea background;
        private int width;
        private int height;
        private int nextFreeWidgetId = 0;

        public Builder(TextureArea background, int width, int height) {
            Preconditions.checkNotNull((Object)background);
            this.background = background;
            this.width = width;
            this.height = height;
        }

        public Builder widget(Widget widget) {
            Preconditions.checkNotNull((Object)widget);
            this.widgets.put((Object)this.nextFreeWidgetId++, (Object)widget);
            return this;
        }

        public Builder label(int x, int y, String localizationKey) {
            return this.widget(new LabelWidget(x, y, localizationKey, new Object[0]));
        }

        public Builder label(int x, int y, String localizationKey, int color) {
            return this.widget(new LabelWidget(x, y, localizationKey, color, new Object[0]));
        }

        public Builder image(int x, int y, int width, int height, TextureArea area) {
            return this.widget(new ImageWidget(x, y, width, height, area));
        }

        public Builder dynamicLabel(int x, int y, Supplier<String> text, int color) {
            return this.widget(new DynamicLabelWidget(x, y, text, color));
        }

        public Builder slot(IItemHandlerModifiable itemHandler, int slotIndex, int x, int y, TextureArea ... overlays) {
            return this.widget(new SlotWidget(itemHandler, slotIndex, x, y).setBackgroundTexture(overlays));
        }

        public Builder progressBar(DoubleSupplier progressSupplier, int x, int y, int width, int height, TextureArea texture, ProgressWidget.MoveType moveType) {
            return this.widget(new ProgressWidget(progressSupplier, x, y, width, height, texture, moveType));
        }

        public Builder bindPlayerInventory(InventoryPlayer inventoryPlayer) {
            this.bindPlayerInventory(inventoryPlayer, GuiTextures.SLOT);
            return this;
        }

        public Builder bindPlayerInventory(InventoryPlayer inventoryPlayer, int startY) {
            this.bindPlayerInventory(inventoryPlayer, GuiTextures.SLOT, 8, startY);
            return this;
        }

        public Builder bindPlayerInventory(InventoryPlayer inventoryPlayer, TextureArea imageLocation) {
            return this.bindPlayerInventory(inventoryPlayer, imageLocation, 8, 84);
        }

        public Builder bindPlayerInventory(InventoryPlayer inventoryPlayer, TextureArea imageLocation, int x, int y) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.widget(new SlotWidget((IItemHandlerModifiable)new PlayerMainInvWrapper(inventoryPlayer), col + (row + 1) * 9, x + col * 18, y + row * 18).setBackgroundTexture(imageLocation).markAsPlayerInventory());
                }
            }
            return this.bindPlayerHotbar(inventoryPlayer, imageLocation, x, y + 58);
        }

        public Builder bindPlayerHotbar(InventoryPlayer inventoryPlayer, TextureArea imageLocation, int x, int y) {
            for (int slot = 0; slot < 9; ++slot) {
                this.widget(new SlotWidget((IItemHandlerModifiable)new PlayerMainInvWrapper(inventoryPlayer), slot, x + slot * 18, y).setBackgroundTexture(imageLocation).markAsPlayerInventory());
            }
            return this;
        }

        public Builder bindOpenListener(Runnable onContainerOpen) {
            this.openListeners.add((Object)onContainerOpen);
            return this;
        }

        public Builder bindCloseListener(Runnable onContainerClose) {
            this.closeListeners.add((Object)onContainerClose);
            return this;
        }

        public ModularUI build(IUIHolder holder, EntityPlayer player) {
            return new ModularUI((ImmutableBiMap<Integer, Widget>)this.widgets.build(), (ImmutableList<Runnable>)this.openListeners.build(), (ImmutableList<Runnable>)this.closeListeners.build(), this.background, this.width, this.height, holder, player);
        }
    }
}

