/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render.shape;

import com.elytradev.architecture.client.proxy.ClientProxy;
import com.elytradev.architecture.client.render.model.IArchitectureModel;
import com.elytradev.architecture.client.render.shape.RenderShape;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.shape.ShapeKind;
import com.elytradev.architecture.common.tile.TileShape;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWindow
extends RenderShape {
    protected static WindowModels frameModels;
    protected static WindowModels cornerModels;
    protected static WindowModels mullionModels;
    protected boolean renderBase;
    protected boolean renderSecondary;
    protected ShapeKind.Window kind;

    public RenderWindow(TileShape te, ITexture[] textures, Trans3 t, RenderTargetBase target, boolean renderBase, boolean renderSecondary, int baseColourMult, int secondaryColourMult) {
        super(te, textures, t, target);
        this.renderBase = renderBase;
        this.renderSecondary = renderSecondary;
        this.kind = (ShapeKind.Window)te.shape.kind;
        this.setBaseColourMult(baseColourMult);
        this.setSecondaryColourMult(secondaryColourMult);
    }

    protected static IArchitectureModel model(String name) {
        if (name != null) {
            return ClientProxy.RENDERING_MANAGER.getModel("shape/window_" + name + ".objson");
        }
        return null;
    }

    protected static IArchitectureModel[] models(String ... names) {
        IArchitectureModel[] result = new IArchitectureModel[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = RenderWindow.model(names[i]);
        }
        return result;
    }

    protected static IArchitectureModel[] models(int n, String name) {
        IArchitectureModel[] result = new IArchitectureModel[n];
        IArchitectureModel m = RenderWindow.model(name);
        for (int i = 0; i < n; ++i) {
            result[i] = m;
        }
        return result;
    }

    public static void init() {
        frameModels = new WindowModels(null, null, RenderWindow.models(4, "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models(4, "glass_edge"));
        cornerModels = new WindowModels(RenderWindow.model("corner_centre"), RenderWindow.models("corner_centre_end0", null, "corner_centre_end2", null), RenderWindow.models("corner_topbot", "frame_side", "corner_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models("corner_topbot_end1", "frame_end1", "corner_topbot_end1", "frame_end1"), RenderWindow.model("corner_glass"), RenderWindow.models("corner_glass_edge", "glass_edge", "corner_glass_edge", "glass_edge"));
        mullionModels = new WindowModels(RenderWindow.model("mullion_centre"), RenderWindow.models("mullion_centre_end0", null, "mullion_centre_end2", null), RenderWindow.models("mullion_topbot", "frame_side", "mullion_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models("mullion_glass_edge", "glass_edge", "mullion_glass_edge", "glass_edge"));
    }

    @Override
    public void render() {
        switch (this.te.shape) {
            case WINDOW_FRAME: {
                this.renderWindow(frameModels);
                break;
            }
            case WINDOW_CORNER: {
                this.renderWindow(cornerModels);
                break;
            }
            case WINDOW_MULLION: {
                this.renderWindow(mullionModels);
            }
        }
    }

    protected void renderWindow(WindowModels models) {
        boolean[][] frame = this.getFrameFlags();
        if (this.renderBase) {
            this.renderModel(this.t, models.centre);
        }
        for (int i = 0; i <= 3; ++i) {
            int j = i - 1 & 3;
            int k = i + 1 & 3;
            Trans3 ts = this.t.t(this.kind.frameTrans[i]);
            if (this.renderBase) {
                if (frame[i][1]) {
                    this.renderModel(ts, models.side[i]);
                } else if (models.centreEnd != null) {
                    this.renderModel(this.t, models.centreEnd[i]);
                }
                if (frame[i][1] && !frame[j][1] || frame[i][0] && frame[j][2]) {
                    this.renderModel(ts, models.end0[i]);
                }
                if (frame[i][1] && !frame[k][1] || frame[i][2] && frame[k][0]) {
                    this.renderModel(ts, models.end1[i]);
                }
            }
            if (!this.renderSecondary || frame[i][1] || frame[i][3]) continue;
            this.renderModel(ts, models.glassEdge[i]);
        }
        if (this.renderSecondary) {
            this.renderModel(this.t, models.glass);
        }
    }

    protected void renderModel(Trans3 t, IArchitectureModel model) {
        if (model != null) {
            model.render(t, this.target, this.getBaseColourMult(), this.getSecondaryColourMult(), this.textures);
        }
    }

    protected boolean[][] getFrameFlags() {
        boolean[][] frame = new boolean[4][4];
        if (this.blockWorld == null) {
            for (int i = 0; i <= 3; ++i) {
                frame[i][1] = true;
            }
        } else {
            int i;
            EnumFacing[] gdir = new EnumFacing[4];
            TileShape[] neighbour = new TileShape[4];
            for (i = 0; i <= 3; ++i) {
                gdir[i] = this.t.t(this.kind.frameSides[i]);
            }
            for (i = 0; i <= 3; ++i) {
                if (this.kind.frameAlways[i]) {
                    frame[i][1] = true;
                    continue;
                }
                TileShape nte = this.getConnectedNeighbourGlobal(this.te, gdir[i]);
                if (nte == null) {
                    frame[i][1] = true;
                    continue;
                }
                int j = i - 1 & 3;
                int k = i + 1 & 3;
                if (this.getConnectedNeighbourGlobal(nte, gdir[j]) == null) {
                    frame[j][2] = true;
                }
                if (this.getConnectedNeighbourGlobal(nte, gdir[k]) == null) {
                    frame[k][0] = true;
                }
                if (nte.secondaryBlockState == null) continue;
                frame[i][3] = true;
            }
        }
        return frame;
    }

    protected void dumpFrameFlags(boolean[][] frame) {
        if (this.te != null && this.te.secondaryBlockState != null) {
            ArchitectureLog.info("RenderWindow.getFrameFlags:\n");
            for (int i = 0; i <= 3; ++i) {
                ArchitectureLog.info("Side %s: %s %s %s\n", i, frame[i][0], frame[i][1], frame[i][2]);
            }
        }
    }

    protected TileShape getConnectedNeighbourGlobal(TileShape te, EnumFacing globalDir) {
        return this.kind.getConnectedWindowGlobal(te, globalDir);
    }

    protected void debug(String fmt, Object ... args) {
        if (this.blockWorld != null && this.te.secondaryBlockState != null) {
            ArchitectureLog.info(fmt, args);
        }
    }

    protected static class WindowModels {
        public IArchitectureModel centre;
        public IArchitectureModel[] centreEnd;
        public IArchitectureModel[] side;
        public IArchitectureModel[] end0;
        public IArchitectureModel[] end1;
        public IArchitectureModel glass;
        public IArchitectureModel[] glassEdge;

        public WindowModels(IArchitectureModel centre, IArchitectureModel[] centreEnd, IArchitectureModel[] side, IArchitectureModel[] end0, IArchitectureModel[] end1, IArchitectureModel glass, IArchitectureModel[] glassEdge) {
            this.centre = centre;
            this.centreEnd = centreEnd;
            this.side = side;
            this.end0 = end0;
            this.end1 = end1;
            this.glass = glass;
            this.glassEdge = glassEdge;
        }
    }
}

