/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.api.internal.util;

import net.minecraft.entity.player.EntityPlayer;

public class EnchantmentHelper {
    public static int getPlayerExperienceTotal(EntityPlayer player) {
        int experienceFromLevel = EnchantmentHelper.getExperienceFromLevel(player.field_71068_ca);
        int experienceBarCapacity = EnchantmentHelper.getExperienceBarCapacity(player.field_71068_ca);
        return (int)((float)experienceFromLevel + player.field_71106_cc * (float)experienceBarCapacity);
    }

    public static void adjustPlayerExperience(EntityPlayer player, int amount) {
        int experience = EnchantmentHelper.getPlayerExperienceTotal(player);
        player.field_71067_cb = Math.max(0, experience + amount);
        player.field_71068_ca = EnchantmentHelper.getLevelFromExperience(player.field_71067_cb);
        player.field_71106_cc = player.field_71067_cb - EnchantmentHelper.getExperienceFromLevel(player.field_71068_ca);
        player.field_71106_cc /= (float)EnchantmentHelper.getExperienceBarCapacity(player.field_71068_ca);
    }

    public static int getExperienceBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceFromLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return EnchantmentHelper.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + EnchantmentHelper.sum(level - 15, 37, 5);
        }
        return 1395 + EnchantmentHelper.sum(level - 30, 112, 9);
    }

    public static int getExperienceToNextLevel(int currentLevel) {
        return EnchantmentHelper.getExperienceToLevel(currentLevel, currentLevel + 1);
    }

    public static int getExperienceToLevel(int startingLevel, int targetLevel) {
        int startingLevelExperience = EnchantmentHelper.getExperienceFromLevel(targetLevel);
        int targetLevelExperience = EnchantmentHelper.getExperienceFromLevel(startingLevel);
        return startingLevelExperience - targetLevelExperience;
    }

    public static int getLevelFromExperience(int experience) {
        int level = 0;
        int experienceForNextLevel;
        while (experience >= (experienceForNextLevel = EnchantmentHelper.getExperienceToNextLevel(level))) {
            ++level;
            experience -= experienceForNextLevel;
        }
        return level;
    }
}

