/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.api.internal.recipe;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class ArtisanIngredient
implements IArtisanIngredient {
    public static final IArtisanIngredient EMPTY = new ArtisanIngredient(Ingredient.field_193370_a);
    private final Ingredient ingredient;

    public static IArtisanIngredient from(@Nullable Ingredient ingredient) {
        if (ingredient == null) {
            return EMPTY;
        }
        return new ArtisanIngredient(ingredient);
    }

    private ArtisanIngredient(@Nonnull Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.ingredient == Ingredient.field_193370_a;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public boolean matches(IArtisanItemStack itemStack) {
        return this.matches(itemStack.toItemStack());
    }

    @Override
    public boolean matches(ItemStack itemStack) {
        return this.ingredient.apply(itemStack);
    }

    @Override
    public boolean matchesIgnoreAmount(IArtisanItemStack itemStack) {
        return this.matchesIgnoreAmount(itemStack.toItemStack());
    }

    @Override
    public boolean matchesIgnoreAmount(ItemStack itemStack) {
        return this.ingredient.apply(itemStack);
    }

    @Override
    public IArtisanItemStack[] getMatchingStacks() {
        ItemStack[] matchingStacks = this.ingredient.func_193365_a();
        IArtisanItemStack[] result = new IArtisanItemStack[matchingStacks.length];
        for (int i = 0; i < matchingStacks.length; ++i) {
            result[i] = ArtisanItemStack.from(matchingStacks[i]);
        }
        return result;
    }

    @Override
    public Ingredient toIngredient() {
        return this.ingredient;
    }
}

