/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.google.common.collect.ImmutableList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;

public class FacingSet
extends AbstractSet<EnumFacing>
implements Set<EnumFacing> {
    private static Collection<EnumFacing>[] facings = new Collection[64];
    int mask;

    @Override
    public int size() {
        return facings[this.mask].size();
    }

    @Override
    public boolean isEmpty() {
        return this.mask == 0;
    }

    @Override
    public boolean contains(Object o) {
        EnumFacing facing = (EnumFacing)o;
        return (this.mask & 1 << facing.ordinal()) != 0;
    }

    @Override
    @Nonnull
    public Iterator<EnumFacing> iterator() {
        return facings[this.mask].iterator();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return facings[this.mask].toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        return facings[this.mask].toArray(a);
    }

    @Override
    public boolean add(EnumFacing facing) {
        if ((this.mask & 1 << facing.ordinal()) == 0) {
            this.mask |= 1 << facing.ordinal();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        EnumFacing facing = (EnumFacing)o;
        if ((this.mask & 1 << facing.ordinal()) != 0) {
            this.mask &= ~(1 << facing.ordinal());
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.mask = 0;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            for (EnumFacing facing : EnumFacing.values()) {
                if ((i & 1 << facing.ordinal()) == 0) continue;
                list.add(facing);
            }
            FacingSet.facings[i] = ImmutableList.copyOf(list);
        }
    }
}

