/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapter;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetworkIngredients;

public class IngredientChannelIndexed<T, M>
extends IngredientChannelAdapter<T, M> {
    private final IIngredientPositionsIndex<T, M> index;

    public IngredientChannelIndexed(PositionedAddonsNetworkIngredients<T, M> network, int channel, IIngredientPositionsIndex<T, M> index) {
        super(network, channel);
        this.index = index;
    }

    @Override
    protected Iterator<PartPos> getNonFullPositions() {
        return this.getNetwork().getPositions(this.getChannel()).iterator();
    }

    @Override
    protected Iterator<PartPos> getAllPositions() {
        return this.getNetwork().getPositions(this.getChannel()).iterator();
    }

    @Override
    protected Iterator<PartPos> getNonEmptyPositions() {
        return this.index.getNonEmptyPositions();
    }

    @Override
    protected Iterator<PartPos> getMatchingPositions(@Nonnull T prototype, M matchFlags) {
        return this.index.getPositions(prototype, matchFlags);
    }

    public Iterator<T> iterator() {
        return this.index.iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchFlags) {
        return this.index.iterator(prototype, matchFlags);
    }

    @Override
    protected boolean canExtract(T extractedSimulated) {
        return this.index.getQuantity(extractedSimulated) >= this.getComponent().getMatcher().getQuantity(extractedSimulated);
    }
}

