/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerConfig;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.UnknownPartEvent;
import org.cyclops.integrateddynamics.core.part.PartTypes;

public class PartHelpers {
    @Nullable
    public static IPartContainer getPartContainer(IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return (IPartContainer)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side, PartContainerConfig.CAPABILITY);
    }

    @Nullable
    public static IPartContainer getPartContainer(DimPos dimPos, @Nullable EnumFacing side) {
        return (IPartContainer)TileHelpers.getCapability((DimPos)dimPos, (EnumFacing)side, PartContainerConfig.CAPABILITY);
    }

    public static IPartType validatePartType(INetwork network, String partTypeName, @Nullable IPartType partType) {
        if (network != null && partType == null) {
            UnknownPartEvent event = new UnknownPartEvent(network, partTypeName);
            network.getEventBus().post(event);
            partType = event.getPartType();
        }
        return partType;
    }

    public static void writePartTypeToNBT(NBTTagCompound partTag, EnumFacing side, IPartType partType) {
        partTag.func_74778_a("__partType", partType.getName());
        partTag.func_74778_a("__side", side.func_176610_l());
    }

    public static boolean writePartToNBT(BlockPos pos, NBTTagCompound partTag, Pair<EnumFacing, PartStateHolder<?, ?>> partData) {
        IPartType part = ((PartStateHolder)partData.getValue()).getPart();
        Object partState = ((PartStateHolder)partData.getValue()).getState();
        PartHelpers.writePartTypeToNBT(partTag, (EnumFacing)partData.getKey(), part);
        try {
            part.toNBT(partTag, partState);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IntegratedDynamics.clog(Level.ERROR, String.format("The part %s at position %s was errored and is removed.", part.getName(), pos));
            return false;
        }
    }

    public static void writePartsToNBT(BlockPos pos, NBTTagCompound tag, Map<EnumFacing, PartStateHolder<?, ?>> partData) {
        NBTTagList partList = new NBTTagList();
        Iterator<Map.Entry<EnumFacing, PartStateHolder<?, ?>>> iterator = partData.entrySet().iterator();
        while (iterator.hasNext()) {
            NBTTagCompound partTag = new NBTTagCompound();
            Map.Entry<EnumFacing, PartStateHolder<?, ?>> entry = iterator.next();
            if (!PartHelpers.writePartToNBT(pos, partTag, Pair.of((Object)entry.getKey(), entry.getValue()))) continue;
            partList.func_74742_a((NBTBase)partTag);
        }
        tag.func_74782_a("parts", (NBTBase)partList);
    }

    public static Pair<EnumFacing, IPartType> readPartTypeFromNBT(@Nullable INetwork network, BlockPos pos, NBTTagCompound partTag) {
        String partTypeName = partTag.func_74779_i("__partType");
        IPartType partType = PartHelpers.validatePartType(network, partTypeName, PartTypes.REGISTRY.getPartType(partTypeName));
        if (partType != null) {
            EnumFacing side = EnumFacing.func_176739_a((String)partTag.func_74779_i("__side"));
            if (side != null) {
                return Pair.of((Object)side, (Object)partType);
            }
            IntegratedDynamics.clog(Level.WARN, String.format("The part %s at position %s was at an invalid side and removed.", partType.getName(), pos));
        } else {
            IntegratedDynamics.clog(Level.WARN, String.format("The part %s at position %s was unknown and removed.", partTypeName, pos));
        }
        return null;
    }

    public static Pair<EnumFacing, ? extends PartStateHolder<?, ?>> readPartFromNBT(@Nullable INetwork network, BlockPos pos, NBTTagCompound partTag) {
        Pair<EnumFacing, IPartType> partData = PartHelpers.readPartTypeFromNBT(network, pos, partTag);
        if (partData != null) {
            Object partState = ((IPartType)partData.getValue()).fromNBT(partTag);
            return Pair.of((Object)partData.getKey(), PartStateHolder.of((IPartType)partData.getValue(), partState));
        }
        return null;
    }

    public static void readPartsFromNBT(@Nullable INetwork network, BlockPos pos, NBTTagCompound tag, Map<EnumFacing, PartStateHolder<?, ?>> partData, @Nullable World world) {
        ImmutableMap oldPartData = ImmutableMap.copyOf(partData);
        partData.clear();
        NBTTagList partList = tag.func_150295_c("parts", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (int i = 0; i < partList.func_74745_c(); ++i) {
            NBTTagCompound partTag = partList.func_150305_b(i);
            Pair<EnumFacing, ? extends PartStateHolder<?, ?>> part = PartHelpers.readPartFromNBT(network, pos, partTag);
            if (part == null) continue;
            partData.put((EnumFacing)part.getKey(), (PartStateHolder<?, ?>)part.getValue());
        }
        if (world != null && world.field_72995_K) {
            boolean triggerBlockRenderUpdate = false;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Object newPartState;
                PartStateHolder oldData = (PartStateHolder)oldPartData.get(side);
                PartStateHolder<?, ?> newData = partData.get(side);
                if (oldData == null && newData == null) continue;
                IPartType oldPartType = oldData != null ? oldData.getPart() : null;
                IPartType<?, ?> newPartType = newData != null ? newData.getPart() : null;
                Object oldPartState = oldData != null ? (Object)oldData.getState() : null;
                Object s = newPartState = newData != null ? (Object)newData.getState() : null;
                if (oldPartType == newPartType && !oldPartType.shouldTriggerBlockRenderUpdate(oldPartState, newPartState)) continue;
                triggerBlockRenderUpdate = true;
                break;
            }
            if (triggerBlockRenderUpdate) {
                world.func_175704_b(pos, pos);
            }
        }
    }

    public static boolean removePart(World world, BlockPos pos, EnumFacing side, @Nullable EntityPlayer player, boolean destroyIfEmpty, boolean dropMainElement, boolean saveState) {
        boolean removeCompletely;
        IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, pos, side);
        ICableFakeable cableFakeable = CableHelpers.getCableFakeable((IBlockAccess)world, pos, side);
        partContainer.removePart(side, player, dropMainElement, saveState);
        boolean bl = removeCompletely = destroyIfEmpty && (cableFakeable == null || !cableFakeable.isRealCable()) && !partContainer.hasParts();
        if (removeCompletely) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        } else {
            world.func_175685_c(pos, world.func_180495_p(pos).func_177230_c(), true);
            if (CableHelpers.getCable((IBlockAccess)world, pos.func_177972_a(side), side.func_176734_d()) != null) {
                CableHelpers.updateConnections((IBlockAccess)world, pos, side);
                CableHelpers.updateConnections((IBlockAccess)world, pos.func_177972_a(side), side.func_176734_d());
                NetworkHelpers.initNetwork(world, pos, side);
            }
        }
        return !removeCompletely;
    }

    public static boolean addPart(World world, BlockPos pos, EnumFacing side, IPartType partType, ItemStack itemStack) {
        IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!world.field_72995_K) {
                partContainer.setPart(side, partType, partType.getState(itemStack));
            }
            return true;
        }
        return false;
    }

    public static boolean addPart(World world, BlockPos pos, EnumFacing side, IPartType partType, IPartState partState) {
        IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!world.field_72995_K) {
                partContainer.setPart(side, partType, partState);
            }
            return true;
        }
        return false;
    }

    public static boolean setPart(@Nullable INetwork network, World world, BlockPos pos, EnumFacing side, IPartType part, IPartState partState, IPartStateHolderCallback callback) {
        callback.onSet(PartStateHolder.of(part, partState));
        if (network != null) {
            IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, pos, side);
            INetworkElement networkElement = part.createNetworkElement(partContainer, DimPos.of((World)world, (BlockPos)pos), side);
            if (!network.addNetworkElement(networkElement, false)) {
                partState = part.getDefaultState();
                callback.onSet(PartStateHolder.of(part, partState));
                IntegratedDynamics.clog(Level.WARN, "A part already existed in the network, this is possibly a result from item duplication.");
                network.addNetworkElement(networkElement, false);
            }
            return true;
        }
        return false;
    }

    public static boolean canInteractWith(PartTarget target, EntityPlayer player, IPartContainer expectedPartContainer) {
        BlockPos blockPos = target.getCenter().getPos().getBlockPos();
        IPartContainer partContainer = PartHelpers.getPartContainer(target.getCenter().getPos(), target.getCenter().getSide());
        return partContainer == expectedPartContainer && player.func_70092_e((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nullable
    public static PartStateHolder<?, ?> getPart(PartPos partPos) {
        EnumFacing side = partPos.getSide();
        IPartContainer partContainer = PartHelpers.getPartContainer(partPos.getPos(), partPos.getSide());
        if (partContainer != null && partContainer.hasPart(side)) {
            return PartStateHolder.of(partContainer.getPart(side), partContainer.getPartState(side));
        }
        return null;
    }

    public static interface IPartStateHolderCallback {
        public void onSet(PartStateHolder<?, ?> var1);
    }

    public static class PartStateHolder<P extends IPartType<P, S>, S extends IPartState<P>> {
        private final IPartType<P, S> part;
        private final S state;

        public static PartStateHolder<?, ?> of(IPartType part, IPartState partState) {
            return new PartStateHolder(part, partState);
        }

        @ConstructorProperties(value={"part", "state"})
        public PartStateHolder(IPartType<P, S> part, S state) {
            this.part = part;
            this.state = state;
        }

        public IPartType<P, S> getPart() {
            return this.part;
        }

        public S getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartStateHolder)) {
                return false;
            }
            PartStateHolder other = (PartStateHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPartType<P, S> this$part = this.getPart();
            IPartType<P, S> other$part = other.getPart();
            if (this$part == null ? other$part != null : !this$part.equals(other$part)) {
                return false;
            }
            S this$state = this.getState();
            S other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartStateHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPartType<P, S> $part = this.getPart();
            result = result * 59 + ($part == null ? 43 : $part.hashCode());
            S $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "PartHelpers.PartStateHolder(part=" + this.getPart() + ", state=" + this.getState() + ")";
        }
    }
}

