/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.events;

import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementAboutToLoadEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementBuildEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementCompletionEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementCriterionCompletedEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.AdvancementVisibilityEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.DamageSourceEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.FunctionReloadEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.GrantCriterionEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.MapGenEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.MapGenStructureEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.MinecraftServerPostTickEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.OnItemRightClickEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.WorldProviderEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.WorldServerEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BNBEventFactory {
    public static boolean onMapGenGenerate(MapGenBase mapGen, World world) {
        return MinecraftForge.EVENT_BUS.post((Event)new MapGenEvent.Generate(mapGen, world));
    }

    public static boolean onStructureGenerate(MapGenStructure structure, World world) {
        return MinecraftForge.EVENT_BUS.post((Event)new MapGenStructureEvent.GenerateStructure(world, structure));
    }

    public static boolean onIsInsideStructure(MapGenStructure structure, World world) {
        return MinecraftForge.EVENT_BUS.post((Event)new MapGenStructureEvent.IsInsideStructure(world, structure));
    }

    public static boolean onIsPositionInStructure(MapGenStructure structure, World world) {
        return MinecraftForge.EVENT_BUS.post((Event)new MapGenStructureEvent.IsPositionInStructure(world, structure));
    }

    public static boolean onGetClosestStrongholdPos(MapGenStructure structure, World world) {
        return MinecraftForge.EVENT_BUS.post((Event)new MapGenStructureEvent.GetClosestStrongholdPos(world, structure));
    }

    public static IChunkGenerator onCreateChunkGenerator(IChunkGenerator chunkGenerator, WorldProvider worldProvider) {
        WorldProviderEvent.CreateChunkGenerator event = new WorldProviderEvent.CreateChunkGenerator(chunkGenerator, worldProvider);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.chunkGenerator;
    }

    public static void onRegisterWorldPre(WorldProvider worldProvider, World world) {
        MinecraftForge.EVENT_BUS.post((Event)new WorldProviderEvent.RegisterWorld.Pre(worldProvider, world));
    }

    public static void onRegisterWorldPost(WorldProvider worldProvider) {
        MinecraftForge.EVENT_BUS.post((Event)new WorldProviderEvent.RegisterWorld.Post(worldProvider));
    }

    public static void onInitDamageSource(DamageSource source) {
        MinecraftForge.EVENT_BUS.post((Event)new DamageSourceEvent.Init(source));
    }

    public static ActionResult<ItemStack> onUseItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        OnItemRightClickEvent event = new OnItemRightClickEvent(world, player, itemStack, hand);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new ActionResult(event.getEnumResult(), (Object)itemStack);
        }
        return itemStack.func_77973_b().func_77659_a(world, player, hand);
    }

    public static void onAdvancementBuildPre(Map<ResourceLocation, Advancement.Builder> advancementMap) {
        MinecraftForge.EVENT_BUS.post((Event)new AdvancementBuildEvent.Pre(advancementMap));
    }

    public static void onAdvancementBuildPost(AdvancementList advancementList) {
        MinecraftForge.EVENT_BUS.post((Event)new AdvancementBuildEvent.Post(advancementList));
    }

    public static void onFunctionReloadPost(FunctionManager manager) {
        MinecraftForge.EVENT_BUS.post((Event)new FunctionReloadEvent.Post(manager));
    }

    public static void onAdvancementCriterionCompleted(EntityPlayerMP player, Advancement advancement, AdvancementProgress progress) {
        MinecraftForge.EVENT_BUS.post((Event)new AdvancementCriterionCompletedEvent(player, advancement, progress));
    }

    public static AdvancementAboutToLoadEvent onAdvancementAboutToLoad(Reader reader, ResourceLocation location) throws IOException {
        JsonReader jsonReader = new JsonReader(reader);
        jsonReader.setLenient(false);
        JsonParser parser = new JsonParser();
        JsonElement json = parser.parse(jsonReader);
        AdvancementAboutToLoadEvent event = new AdvancementAboutToLoadEvent(location, json);
        return event;
    }

    public static boolean onCriterionGranted(PlayerAdvancements playerAdvancements, Advancement advancement, String criterionName) {
        return MinecraftForge.EVENT_BUS.post((Event)new GrantCriterionEvent(playerAdvancements, advancement, criterionName));
    }

    public static boolean onWorldServerTickPre() {
        return MinecraftForge.EVENT_BUS.post((Event)new WorldServerEvent.Tick.Pre());
    }

    public static boolean onWorldServerUpdateEntitiesPre() {
        return MinecraftForge.EVENT_BUS.post((Event)new WorldServerEvent.UpdateEntities.Pre());
    }

    public static boolean onMinecraftServerPostTickEvent() {
        return MinecraftForge.EVENT_BUS.post((Event)new MinecraftServerPostTickEvent());
    }

    public static void test(boolean bool) {
        if (!bool) {
            BNBEventFactory.test2();
        }
    }

    public static void test2() {
    }

    public static boolean onAdvancementVisibilityEvent(Advancement advancement, PlayerAdvancements advancements) {
        return MinecraftForge.EVENT_BUS.post((Event)new AdvancementVisibilityEvent(advancement, advancements));
    }

    public static boolean onAdvancementCompletionEvent(AdvancementProgress progress) {
        return MinecraftForge.EVENT_BUS.post((Event)new AdvancementCompletionEvent(progress));
    }
}

