/*
 * Decompiled with CFR 0.152.
 */
package rustic.core;

import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rustic.client.EventHandlerClient;
import rustic.common.Config;
import rustic.common.EventHandlerCommon;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.fluids.ModFluids;
import rustic.common.crafting.Recipes;
import rustic.common.items.ModItems;
import rustic.common.potions.EventHandlerPotions;
import rustic.compat.Compat;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import rustic.compat.dynamictrees.DynamicTreesCompat;
import rustic.core.CommonProxy;

@Mod(modid="rustic", name="Rustic", version="1.1.0", dependencies="after:dynamictrees@[1.12.2-0.9.1e,);after:dynamictreesbop;before:dynamictreestc", acceptedMinecraftVersions="[1.12.2]")
public class Rustic {
    public static final String MODID = "rustic";
    public static final String NAME = "Rustic";
    public static final String VERSION = "1.1.0";
    public static final String DEPENDENCIES = "after:dynamictrees@[1.12.2-0.9.1e,);after:dynamictreesbop;before:dynamictreestc";
    @SidedProxy(clientSide="rustic.core.ClientProxy", serverSide="rustic.core.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs decorTab;
    public static CreativeTabs farmingTab;
    public static CreativeTabs alchemyTab;
    @Mod.Instance
    public static Rustic instance;
    public static final Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCommon());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerPotions());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preInit(event);
        if (Loader.isModLoaded((String)"crafttweaker")) {
            CraftTweakerHelper.preInit();
        }
        if (Loader.isModLoaded((String)"dynamictrees")) {
            MinecraftForge.EVENT_BUS.register(DynamicTreesCompat.class);
        }
    }

    @SubscribeEvent
    public void initRecipes(RegistryEvent.Register<IRecipe> event) {
        Recipes.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        if (Loader.isModLoaded((String)"forestry") && Config.ENABLE_FORESTRY_COMPAT) {
            Compat.doForestryCompat();
        }
    }

    static {
        decorTab = new CreativeTabs("rustic.decor"){

            public String func_78013_b() {
                return "rustic.decor";
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((Block)ModBlocks.VASE);
            }
        };
        farmingTab = new CreativeTabs("rustic.farming"){

            public String func_78013_b() {
                return "rustic.farming";
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((Item)ModItems.OLIVES);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> p_78018_1_) {
                for (Object obj : Item.field_150901_e) {
                    Item item = (Item)obj;
                    if (item == null) continue;
                    for (CreativeTabs tab : item.getCreativeTabs()) {
                        if (tab != this) continue;
                        item.func_150895_a((CreativeTabs)this, p_78018_1_);
                    }
                }
                Iterator<Fluid> iterator = ModFluids.getFluids().iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = new ItemStack((Item)ForgeModContainer.getInstance().universalBucket);
                    FluidBucketWrapper fluidHandler = new FluidBucketWrapper(stack);
                    Fluid fluid = iterator.next();
                    FluidStack fs = new FluidStack(fluid, ForgeModContainer.getInstance().universalBucket.getCapacity());
                    if (fluidHandler.fill(fs, true) != fs.amount) continue;
                    ItemStack filled = fluidHandler.getContainer();
                    p_78018_1_.add((Object)filled);
                }
            }
        };
        alchemyTab = new CreativeTabs("rustic.alchemy"){

            public String func_78013_b() {
                return "rustic.alchemy";
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return ModItems.ELIXIR.func_190903_i();
            }
        };
        logger = LogManager.getLogger((String)MODID);
        FluidRegistry.enableUniversalBucket();
    }
}

