/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vacuum.chest;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.inventory.EnderInventory;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.machines.machine.vacuum.chest.ContainerVacuumChest;
import crazypants.enderio.machines.machine.vacuum.chest.GuiVacuumChest;
import crazypants.enderio.machines.machine.vacuum.chest.TileVacuumChest;
import crazypants.enderio.machines.machine.vacuum.chest.VacuumRenderMapper;
import crazypants.enderio.util.ClientUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVacuumChest
extends BlockEio<TileVacuumChest>
implements ISmartRenderAwareBlock,
IEioGuiHandler.WithPos,
IResourceTooltipProvider,
IRedstoneConnectable,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint,
IHaveRenderers {
    public static BlockVacuumChest create(@Nonnull IModObject modObject) {
        BlockVacuumChest res = new BlockVacuumChest(modObject);
        res.init();
        return res;
    }

    protected BlockVacuumChest(@Nonnull IModObject modObject) {
        super(modObject);
        this.initDefaultState();
        this.setShape(this.mkShape(BlockFaceShape.BOWL));
    }

    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)EnumRenderMode.RENDER, (Comparable)EnumRenderMode.AUTO));
    }

    public boolean shouldRedstoneConduitConnect(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing from) {
        return true;
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos fromPos) {
        TileVacuumChest ent = (TileVacuumChest)this.getTileEntity((IBlockAccess)world, pos);
        if (ent != null) {
            ent.onNeighborBlockChange(state, world, fromPos, neighborBlock, fromPos);
        }
    }

    protected void init() {
        super.init();
        this.registerInSmartModelAttacher();
    }

    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public final IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
        TileVacuumChest tileEntity = (TileVacuumChest)this.getTileEntitySafe(world, pos);
        if (tileEntity != null) {
            this.setBlockStateWrapperCache((IBlockStateWrapper)blockStateWrapper, world, pos, tileEntity);
        }
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileVacuumChest tileEntity) {
        blockStateWrapper.addCacheKey((Object)0);
    }

    @Nonnull
    protected BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return VacuumRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return VacuumRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(@Nonnull IBlockState blockStateIn) {
        return false;
    }

    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        TileVacuumChest te = (TileVacuumChest)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return new ContainerVacuumChest(player.field_71071_by, te);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        TileVacuumChest te = (TileVacuumChest)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return new GuiVacuumChest(player.field_71071_by, te);
        }
        return null;
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_149739_a();
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects((IBlockState)state, (World)world, (RayTraceResult)target, (ParticleManager)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects((World)world, (BlockPos)pos, (ParticleManager)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ClientUtil.registerDefaultItemRenderer((IModObject)modObject);
    }

    public boolean func_149740_M(@Nonnull IBlockState state) {
        return true;
    }

    public int func_180641_l(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        TileVacuumChest te = (TileVacuumChest)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        EnderInventory inv = te.getInventory();
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

