/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.init;

import crazypants.enderio.machines.init.MachineObject;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EIOMDataFixer {
    static boolean ENABLED = false;

    public static void register() {
        if (ENABLED) {
            ModFixs fixs = FMLCommonHandler.instance().getDataFixer().init("enderiomachines", 1);
            fixs.registerFix((IFixType)FixTypes.CHUNK, (IFixableData)new TankBlockStateFixer());
            fixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new TankItemDamageFixer());
        }
    }

    private static final class TankBlockStateFixer
    implements IFixableData {
        private TankBlockStateFixer() {
        }

        public int func_188216_a() {
            return 0;
        }

        @Nonnull
        public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound compound) {
            Block blockOld = MachineObject.block_tank.getBlockNN();
            int blockIDOld = Block.func_149682_b((Block)blockOld);
            int stateOld = blockOld.func_176201_c(blockOld.func_176223_P());
            Block blockNew = MachineObject.block_tank.getBlockNN();
            int blockIDNew = Block.func_149682_b((Block)blockNew);
            int stateNew = blockNew.func_176201_c(blockNew.func_176223_P());
            NBTTagCompound level = compound.func_74775_l("Level");
            NBTTagList sections = level.func_150295_c("Sections", 10);
            for (int l = 0; l < sections.func_74745_c(); ++l) {
                NBTTagCompound section = sections.func_150305_b(l);
                byte[] blockIDs = section.func_74770_j("Blocks");
                NibbleArray data = new NibbleArray(section.func_74770_j("Data"));
                NibbleArray blockIdExtension = section.func_150297_b("Add", 7) ? new NibbleArray(section.func_74770_j("Add")) : null;
                for (int i = 0; i < blockIDs.length; ++i) {
                    int extension = blockIdExtension == null ? 0 : blockIdExtension.func_177480_a(i);
                    int blockID = extension << 8 | blockIDs[i] & 0xFF;
                    if (blockID != blockIDOld || data.func_177480_a(i) == stateOld) continue;
                    blockIDs[i] = (byte)(blockIDNew & 0xFF);
                    if (blockIdExtension != null) {
                        blockIdExtension.func_177482_a(i, blockIDNew >> 8 & 0xF);
                    }
                    data.func_177482_a(i, stateNew);
                }
            }
            return compound;
        }
    }

    private static final class TankItemDamageFixer
    implements IFixableData {
        private TankItemDamageFixer() {
        }

        public int func_188216_a() {
            return 0;
        }

        @Nonnull
        public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound compound) {
            String nameOld = MachineObject.block_tank.getRegistryName().toString();
            String nameNew = MachineObject.block_tank.getRegistryName().toString();
            if (nameOld.equals(compound.func_74779_i("id")) && compound.func_74765_d("Damage") > 0) {
                compound.func_74778_a("id", nameNew);
                compound.func_74777_a("Damage", (short)0);
            }
            return compound;
        }
    }
}

