/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.api.utils.JsonUtil;

public class PropPlaceBlockStructure
extends BaseResourceProperty
implements IResourceEffect {
    Map<BlockPos, BlockEntry> blocksToSpawn = new LinkedHashMap<BlockPos, BlockEntry>();

    public PropPlaceBlockStructure(JsonObject obj) {
        super(obj, "place_block_structure");
        JsonUtil.convertToObject(obj.get("blocks"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                final BlockEntry block = JsonUtil.createBlockWithMeta(t);
                JsonUtil.convertToObject(t.get("positions"), new Consumer<JsonObject>(){

                    @Override
                    public void accept(JsonObject t) {
                        PropPlaceBlockStructure.this.blocksToSpawn.put(new BlockPos(t.get("x").getAsInt(), t.get("y").getAsInt(), t.get("z").getAsInt()), block);
                    }
                });
            }
        });
        this.setJEIInfo("Places a Structure");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        for (Map.Entry<BlockPos, BlockEntry> entry : this.blocksToSpawn.entrySet()) {
            world.func_180501_a(pos.func_177971_a((Vec3i)entry.getKey()), entry.getValue().getBlockState(), 2);
        }
        return true;
    }

    public static class PlaceBlockStructureFactory
    extends BaseResourceFactory {
        public PlaceBlockStructureFactory() {
            super("place_block_structure", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlaceBlockStructure(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject position = new JsonObject();
            position.addProperty("x", (Number)-1);
            position.addProperty("y", (Number)-1);
            position.addProperty("z", (Number)-1);
            JsonObject blocks = new JsonObject();
            JsonArray array = new JsonArray();
            array.add((JsonElement)position);
            blocks.add("positions", (JsonElement)array);
            blocks.addProperty("name", "minecraft:dirt");
            array = new JsonArray();
            array.add((JsonElement)blocks);
            obj.add("blocks", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to place a customized Structure");
            MapElement positions = new MapElement("");
            positions.addElement(new IntElement("x", 0).setDescription("The XOffset for the Block that should be placed of the Clicked Block."));
            positions.addElement(new IntElement("y", 0).setDescription("The YOffset for the Block that should be placed of the Clicked Block."));
            positions.addElement(new IntElement("z", 0).setDescription("The ZOffset for the Block that should be placed of the Clicked Block."));
            MapElement block = new MapElement("");
            block.addElement(new TextElement("name", "").setDescription("The Block that should be placed"));
            block.addElement(new IntElement("meta", 0, "The Metadata that should be placed with the block"));
            block.addElement(new OptionalArrayElement("positions", positions));
            map.addElement(new OptionalArrayElement("blocks", block));
            return map;
        }
    }
}

