/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathModifier;
import scavenge.api.utils.JsonUtil;

public class PropChangeMeta
extends BaseResourceProperty
implements IResourceEffect {
    IMathModifier mod;

    public PropChangeMeta(JsonObject obj) {
        super(obj, "change_meta");
        if (obj.has("meta")) {
            this.mod = new StaticMod(obj.get("meta").getAsInt());
        } else if (obj.has("metas")) {
            this.mod = new RandomMod(JsonUtil.convertToInts(obj.get("metas")));
        } else if (obj.has("metaMap")) {
            final HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            JsonUtil.convertToObject((JsonElement)obj, new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    List<Integer> targets = JsonUtil.convertToInts(t.get("target"));
                    int result = t.get("result").getAsInt();
                    for (Integer target : targets) {
                        map.put(target.longValue(), result);
                    }
                }
            });
            this.mod = new MapMod(map);
        } else {
            throw new RuntimeException("Require a meta type");
        }
        this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        Block block = state.func_177230_c();
        int meta = (int)this.mod.modify(block.func_176201_c(state));
        world.func_175656_a(pos, block.func_176203_a(meta));
        return true;
    }

    public static class MapMod
    implements IMathModifier {
        Map<Long, Integer> mods = new HashMap<Long, Integer>();

        public MapMod(Map<Long, Integer> mods) {
            this.mods.putAll(mods);
        }

        @Override
        public long modify(long input) {
            return this.mods.get(input).longValue();
        }

        @Override
        public String getID() {
            return "Ignore!";
        }
    }

    public static class RandomMod
    implements IMathModifier {
        public static final Random rand = new Random();
        List<Integer> metas = new ArrayList<Integer>();

        public RandomMod(List<Integer> meta) {
            this.metas.addAll(meta);
        }

        @Override
        public long modify(long input) {
            return this.metas.get(rand.nextInt(this.metas.size())).intValue();
        }

        @Override
        public String getID() {
            return "Ignore!";
        }
    }

    public static class StaticMod
    implements IMathModifier {
        long value;

        public StaticMod(int value) {
            this.value = value;
        }

        @Override
        public long modify(long input) {
            return this.value;
        }

        @Override
        public String getID() {
            return "Ignore!";
        }
    }

    public static class ChangeMetaFactory
    extends BaseResourceFactory {
        public ChangeMetaFactory() {
            super("change_meta", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropChangeMeta(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("meta", (Number)0);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to change the Metadata of the block");
            ChoiceElement choice = new ChoiceElement("", 3);
            choice.addElement(0, new IntElement("meta", 0).setDescription("The meta the block should turn into"));
            choice.addElement(1, new ArrayElement("metas", new IntElement("", 0)).setDescription("A Pool where a random meta is pickt from"));
            MapElement data = new MapElement("metaMap");
            data.addElement(new ArrayElement("target", new IntElement("", 0)).setDescription("Metas that should be checkt for"));
            data.addElement(new IntElement("result", 0).setDescription("What the BlockMeta should turn into"));
            choice.addElement(2, new OptionalArrayElement("metaMap", data));
            map.addElement(choice);
            return map;
        }
    }
}

