/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockEffects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;

public class PropOffsetEffect
extends BaseResourceProperty
implements IResourceEffect {
    IResourceEffect effect;
    EnumFacing side;

    public PropOffsetEffect(JsonObject obj) {
        super(obj, "offset_effect");
        this.effect = this.createEffect(obj.getAsJsonObject("effect"));
        this.side = EnumFacing.func_176739_a((String)obj.get("direction").getAsString());
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Offsets a Effect to " + this.side.func_176610_l());
        this.effect.addJEIData(collector);
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        pos = pos.func_177972_a(side);
        state = world.func_180495_p(pos);
        return this.effect.applyEffects(state, world, pos, player, left, side, resourceID, container);
    }

    public static class OffsetEffectFactory
    extends BaseResourceFactory {
        public OffsetEffectFactory() {
            super("offset_effect", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropOffsetEffect(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject object = new JsonObject();
            object.addProperty("type", "exampleEffect");
            obj.add("effect", (JsonElement)object);
            obj.addProperty("direction", "north");
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("direction", "").setDescription("The Side the Effect should be shifted to"));
            map.addElement(new MapElement("effect").setDescription("The Effect that should be offset to another position"));
            map.setDescription("Allows to offset a Effect to another position");
            return map;
        }
    }
}

