/*
 * Decompiled with CFR 0.152.
 */
package scavenge.score.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropAddScore
extends BaseResourceProperty
implements IResourceEffect {
    String id;
    boolean increase;
    int amount;

    public PropAddScore(JsonObject obj) {
        super(obj, "add_score");
        this.id = obj.get("name").getAsString();
        this.increase = JsonUtil.getOrDefault(obj, "increase", true);
        this.amount = JsonUtil.getOrDefault(obj, "amount", 1);
        if (this.increase) {
            this.setJEIInfo("Increases Score [" + this.id + "] by " + this.amount);
        } else {
            this.setJEIInfo("Decreases Score [" + this.id + "] by " + this.amount);
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        Score score = this.getScore(world, player, this.id);
        if (this.increase) {
            score.func_96649_a(this.amount);
        } else {
            score.func_96646_b(this.amount);
        }
        return true;
    }

    public Score getScore(World world, EntityPlayer player, String id) {
        Scoreboard board = world.func_96441_U();
        return board.func_96529_a(player.func_70005_c_(), board.func_96518_b(id));
    }

    public static class AddScoreFactory
    extends BaseResourceFactory {
        public AddScoreFactory() {
            super("add_score", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddScore(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "exampleScore");
            obj.addProperty("increase", Boolean.valueOf(true));
            obj.addProperty("amount", (Number)1);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to modify a Score");
            map.addElement(new TextElement("name", "").setDescription("The Score id of the Score that you want to change"));
            map.addElement(new BooleanElement("increase", true, "If the Score should increase or decrease"));
            map.addElement(new IntElement("amount", 1, "How much the score should increase or decrease"));
            return map;
        }
    }
}

