/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.MathUtils;

public class PropSetXP
extends BaseResourceProperty
implements IResourceEffect {
    boolean level;
    int amount;

    public PropSetXP(JsonObject obj) {
        super(obj, "set_XP");
        this.level = JsonUtil.getOrDefault(obj, "levels", true);
        this.amount = JsonUtil.getOrDefault(obj, "amount", 1);
        if (this.level) {
            this.setJEIInfo("Sets the Player XP Level to " + this.amount);
        } else {
            this.setJEIInfo("Sets the Player XP to " + this.amount);
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        player.field_71068_ca = 0;
        player.func_71023_q(this.level ? MathUtils.getXPForLvl(this.amount) : this.amount);
        return true;
    }

    public static class SetXPFactory
    extends BaseResourceFactory {
        public SetXPFactory() {
            super("set_XP", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSetXP(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("level", Boolean.valueOf(true));
            obj.addProperty("amount", (Number)10);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new BooleanElement("level", true, "If the Set of XP should be amount or Level"));
            map.addElement(new IntElement("amount", 1, "How much the player XP or XP Level should be set to"));
            map.setDescription("Allows to set the Player Experience to a certain level or points");
            return map;
        }
    }
}

