/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropConsumeItem
extends BaseResourceProperty
implements IResourceEffect {
    int amount;
    double chance;
    boolean offHand;

    public PropConsumeItem(JsonObject obj) {
        super(obj, "consume_item");
        this.addIncompat("damage_item");
        this.amount = obj.get("amount").getAsInt();
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        this.offHand = JsonUtil.getOrDefault(obj, "offHand", false);
        this.setJEIInfo("Consumes " + this.amount + " of the " + (this.offHand ? "Off" : "Main") + " Held Item with a [" + this.chance + "%] chance");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.chance >= world.field_73012_v.nextDouble() * 100.0) {
            if (this.offHand) {
                ItemStackHelper.func_188382_a((List)player.field_71071_by.field_184439_c, (int)0, (int)this.amount);
                return true;
            }
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, this.amount);
            return true;
        }
        return false;
    }

    public static class ConsumeItemFactory
    extends BaseResourceFactory {
        public ConsumeItemFactory() {
            super("consume_item", IResourceFactory.PropertyType.Effect);
            this.addIncompat("damage_item", CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropConsumeItem(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("amount", (Number)1);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to consume the held item");
            map.addElement(new IntElement("amount", 0).setDescription("How many items should be consumed"));
            map.addElement(new DoubleElement("chance", 100.0, "how likely it is that the items get consumed"));
            map.addElement(new BooleanElement("offHand", false, "If the Item should be removed from the Main or OffHand"));
            return map;
        }
    }
}

