/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.MathUtils;

public class PropAddXP
extends BaseResourceProperty
implements IResourceEffect {
    int amount;
    boolean remove;

    public PropAddXP(JsonObject obj) {
        super(obj, "add_XP");
        this.remove = JsonUtil.getOrDefault(obj, "remove", false);
        this.amount = JsonUtil.getOrDefault(obj, "amount", 0);
        if (this.remove) {
            this.setJEIInfo("Consumes " + this.amount + " XP Points");
        } else {
            this.setJEIInfo("Adds " + this.amount + " XP Points");
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.remove) {
            int stored = MathUtils.getXP(player) - this.amount;
            if (stored < 0) {
                stored = 0;
            }
            player.field_71067_cb = stored;
            player.field_71068_ca = MathUtils.getLvlForXP(stored);
            player.field_71106_cc = (float)(stored - MathUtils.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
        } else {
            player.func_71023_q(this.amount);
        }
        return true;
    }

    public static class AddXPFactory
    extends BaseResourceFactory {
        public AddXPFactory() {
            super("add_XP", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddXP(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("amount", (Number)100);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new IntElement("amount", 0).setDescription("The Amount of XP that should be added or removed"));
            map.addElement(new BooleanElement("remove", false, "If the XP should be added or removed"));
            map.setDescription("Allows to add or remove XP from a Player");
            return map;
        }
    }
}

