/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropIsFakePlayer
extends BaseResourceProperty
implements IResourceCondition {
    boolean isPlayer;

    public PropIsFakePlayer(JsonObject obj) {
        super(obj, "require_player");
        this.isPlayer = JsonUtil.getOrDefault(obj, "require", true);
        this.setJEIInfo(this.isPlayer ? "Requires a Player" : "Requires a Fake Player");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        if (client) {
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)player).field_71135_a != null == this.isPlayer;
        }
        return !this.isPlayer;
    }

    public static class IsFakePlayerFactory
    extends BaseResourceFactory {
        public IsFakePlayerFactory() {
            super("require_player", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropIsFakePlayer(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check for a Fake Player or Real Player");
            map.addElement(new BooleanElement("require", true, "If the Player should be a RealPlayer"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("require", Boolean.valueOf(true));
        }
    }
}

