/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;

public class PropAddRandomNBTData
extends BaseActiveLootProperty {
    List<NBTTagCompound> data = new ArrayList<NBTTagCompound>();

    public PropAddRandomNBTData(JsonObject obj) {
        super("set_random_nbtData");
        JsonUtil.convertToPrimitive(obj.get("datas"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                String name = t.getAsString();
                if (name.equalsIgnoreCase("empty")) {
                    PropAddRandomNBTData.this.data.add(null);
                    return;
                }
                PropAddRandomNBTData.this.data.add(ScavengeAPI.INSTANCE.getCompound(name));
            }
        });
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        stack.func_77982_d(this.data.get(rand.nextInt(this.data.size())));
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.data.size(); ++i) {
            ItemStack copy = stack.func_77946_l();
            copy.func_77982_d(this.data.get(i));
            list.add(copy);
        }
        return list;
    }

    public static class SetRandomNBTDataFactory
    extends BaseLootFactory {
        public SetRandomNBTDataFactory() {
            super("set_random_nbtData", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropAddRandomNBTData(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new ArrayElement("datas", new TextElement("", "")).setDescription("The NBTCompounds that should be selected from"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive("empty"));
            obj.add("datas", (JsonElement)array);
        }
    }
}

