/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseActiveLootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropAddRandomFluid
extends BaseActiveLootProperty {
    List<FluidStack> list = new ArrayList<FluidStack>();

    public PropAddRandomFluid(JsonObject obj) {
        super("add_random_fluid");
        JsonUtil.convertToObject(obj.get("fluids"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                FluidStack fluid = JsonUtil.createFluidStack(t);
                if (fluid == null) {
                    throw new RuntimeException("Fluid is Null in Object [" + t + "] this is not allowed");
                }
                PropAddRandomFluid.this.list.add(fluid);
            }
        });
    }

    @Override
    public ItemStack applyActiveEffect(ItemStack stack, NBTTagCompound customData) {
        this.addFluid(stack, this.list.get(rand.nextInt(this.list.size())));
        return stack;
    }

    @Override
    public List<ItemStack> applyMultiInfoEffect(ItemStack stack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (FluidStack entry : this.list) {
            ItemStack copy = stack.func_77946_l();
            this.addFluid(copy, entry);
            result.add(copy);
        }
        return result;
    }

    public void addFluid(ItemStack stack, FluidStack fluid) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            int amount = LootUtil.getStackSize(stack);
            LootUtil.setStackSize(stack, 1);
            IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            handler.fill(fluid.copy(), true);
            LootUtil.setStackSize(stack, amount);
        }
    }

    public static class AddRandomFluidFactory
    extends BaseLootFactory {
        public AddRandomFluidFactory() {
            super("add_random_fluid", true);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropAddRandomFluid(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement base = new MapElement("");
            base.addElement(new TextElement("name", "").setDescription("Fluid Registry name for the Fluid that should be added"));
            base.addElement(new IntElement("amount", 1000, "How much fluid should be added"));
            MapElement map = new MapElement("");
            map.addElement(new ArrayElement("fluids", map).addElement(base).setDescription("The Fluids that should be pickt from"));
            map.setDescription("Allows to add a Random Fluid out of a List to the Item");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject object = new JsonObject();
            object.addProperty("name", "minecraft:water");
            object.addProperty("amount", (Number)1000);
            JsonArray array = new JsonArray();
            array.add((JsonElement)object);
            obj.add("fluids", (JsonElement)array);
        }
    }
}

