/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.utils.LootUtil;
import scavenge.core.loot.ILoot;

public class WeightLoot
implements ILoot {
    List<ILoot> loot = new ArrayList<ILoot>();
    int totalLoot = 0;
    boolean shouldShow = true;

    public WeightLoot(List<ILoot> loots) {
        for (ILoot entry : loots) {
            this.totalLoot += entry.getWeight();
            this.loot.add(entry);
            if (entry.shouldShow()) continue;
            this.shouldShow = false;
        }
    }

    @Override
    public List<ItemStack> getDrops(Random rand, NBTTagCompound nbt) {
        int random = rand.nextInt(this.totalLoot);
        for (int i = 0; i < this.loot.size(); ++i) {
            ILoot entry = this.loot.get(i);
            int weight = entry.getWeight();
            if (weight > random) {
                return entry.getDrops(rand, nbt);
            }
            random -= weight;
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean usesWeight() {
        return false;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    public float getChance() {
        return 100.0f;
    }

    @Override
    public int getMaxRools() {
        return Integer.MAX_VALUE;
    }

    @Override
    public List<ItemStack> generateAllDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ILoot entry : this.loot) {
            float chance = (float)entry.getWeight() / (float)this.totalLoot * 100.0f;
            for (ItemStack stack : entry.generateAllDrops()) {
                LootUtil.addToolTip(stack, "Random Drop");
                LootUtil.addToolTip(stack, chance + "% Chance");
                list.add(stack);
            }
        }
        return list;
    }

    @Override
    public boolean shouldShow() {
        return this.shouldShow;
    }
}

