/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.autodoc;

import java.io.BufferedWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import scavenge.api.autodoc.BaseElement;

public class ChoiceElement
extends BaseElement<String> {
    Map<String, BaseElement>[] elements;

    public ChoiceElement(String id, int choices) {
        super(id);
        this.elements = new Map[choices];
        for (int i = 0; i < choices; ++i) {
            this.elements[i] = new LinkedHashMap<String, BaseElement>();
        }
        this.setType("ChoiceType");
    }

    public void addElement(int index, BaseElement element) {
        this.elements[index].put(element.getKey(), element);
    }

    @Override
    public boolean isMultiElement() {
        return true;
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public void writeToBuffer(BufferedWriter writer, boolean showSelf, int layer, boolean printCurse) throws Exception {
        if (this.elements.length == 0 || this.elements.length == 1) {
            return;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (printCurse) {
                writer.write(this.getOffset(layer) + (i == 0 ? "either" : "or"));
                writer.write("<br />");
            } else {
                writer.write(this.getOffset(layer) + (i == 0 ? "either" : "or"));
            }
            writer.newLine();
            for (BaseElement element : this.elements[i].values()) {
                element.writeToBuffer(writer, false, layer + 1, printCurse);
            }
        }
    }

    @Override
    public String toString() {
        return "Choice[ID=" + this.key + "]";
    }
}

