/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import shadows.placebo.Placebo;
import shadows.placebo.block.BlockBasic;
import shadows.placebo.block.IEnumBlockAccess;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.placebo.interfaces.IPlankEnum;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.itemblock.ItemBlockBase;
import shadows.placebo.registry.RegistryInformation;
import shadows.placebo.util.PlaceboUtil;
import shadows.plants2.Plants2;

public class BlockEnumSlab
extends BlockBasic
implements IHasRecipe {
    public static final PropertyEnum<SlabVariant> VARIANT = PropertyEnum.func_177709_a((String)"slab_variant", SlabVariant.class);
    private final IPlankEnum e;

    public <T extends IPlankEnum, B extends Block> BlockEnumSlab(T e, B block) {
        super(e.func_176610_l() + "_slab", ((IEnumBlockAccess)block).getStateFor(e).func_185904_a(), block.field_149782_v, block.field_149781_w, (RegistryInformation)Plants2.INFO);
        this.func_149672_a(block.field_149762_H);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.LOWER)));
        this.e = e;
    }

    public void initModels(ModelRegistryEvent ev) {
        Placebo.PROXY.useRenamedMapper((Block)this, "slabs", ",type=" + this.e.func_176610_l());
        PlaceboUtil.sMRL((String)"slabs", (Block)this, (int)0, (String)("slab_variant=lower,type=" + this.e.func_176610_l()));
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> ev) {
        OreDictionary.registerOre((String)"slabWood", (Block)this);
        Ingredient i = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.e.get()});
        Plants2.HELPER.addShaped(new ItemStack((Block)this, 6), 3, 1, new Object[]{i, i, i});
        Plants2.HELPER.addShaped(this.e.get(), 1, 2, new Object[]{this, this});
    }

    public ItemBlock createItemBlock() {
        return new ItemBlockSlab(this);
    }

    public boolean func_149686_d(IBlockState state) {
        return state == this.getDouble();
    }

    public boolean func_185481_k(IBlockState state) {
        return this.func_149686_d(state) || state == this.getUpper();
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.func_149686_d(state) ? 2 : 1;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((SlabVariant)((Object)state.func_177229_b(VARIANT))).getAABB();
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185900_c(world, pos);
    }

    protected boolean func_149700_E() {
        return true;
    }

    public String func_149739_a() {
        return "tile.plants2.slab." + this.e.func_176610_l();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing facing) {
        IBlockState state2 = blockAccess.func_180495_p(pos.func_177972_a(facing));
        if (!facing.func_176740_k().func_176720_b()) {
            return state2.func_177230_c() != this || state2 != state && this.getDouble() != state2;
        }
        if (facing == EnumFacing.DOWN && state2 == this.getDouble()) {
            return state != this.getLower() && state != state2;
        }
        if (facing == EnumFacing.UP && state2 == this.getDouble()) {
            return state.func_177230_c() != this;
        }
        if (facing == EnumFacing.UP && state == this.getDouble()) {
            return state2 != this.getLower();
        }
        if (facing == EnumFacing.DOWN && state2.func_177230_c() == this) {
            return state2 == state;
        }
        return state2.func_177230_c() != this || state2 != this.getOpposite(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return state == this.getDouble();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((SlabVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return state == this.getUpper();
        }
        if (face == EnumFacing.DOWN) {
            return state == this.getLower();
        }
        return state == this.getDouble();
    }

    public IBlockState getUpper() {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.UPPER));
    }

    public IBlockState getLower() {
        return this.func_176223_P();
    }

    public IBlockState getDouble() {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.DOUBLE));
    }

    public IBlockState getOpposite(IBlockState state) {
        if (state == this.getUpper()) {
            return this.getLower();
        }
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if ((double)hitY >= 0.5) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.UPPER));
        }
        return this.func_176223_P();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.e.isNether() ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.e.isNether() ? 0 : 5;
    }

    private static class ItemBlockSlab
    extends ItemBlockBase {
        private final BlockEnumSlab slab;

        public ItemBlockSlab(BlockEnumSlab slab) {
            super((Block)slab);
            this.slab = slab;
        }

        public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            if (!this.canPlaceOnSide(player, world, pos, hand, facing, hitX, hitY, hitZ)) {
                return EnumActionResult.FAIL;
            }
            ItemStack stack = player.func_184586_b(hand);
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!(block.func_176200_f((IBlockAccess)world, pos) || block == this.field_150939_a && this.checkOppositeByFacing(state, facing))) {
                pos = pos.func_177972_a(facing);
            }
            state = world.func_180495_p(pos);
            IBlockState placeState = this.getByHitY(hitY);
            if (player.func_175151_a(pos, facing, stack) && facing.func_176740_k().func_176720_b() && state.func_177230_c() == this.field_150939_a) {
                placeState = this.slab.getDouble();
                if (this.doubleSlab(world, pos)) {
                    return this.shrinkAndSucceed(world, pos, player, stack);
                }
            } else if (this.validEditable(state, world, pos, facing, stack, player) && facing.func_176740_k().func_176722_c() ? world.func_175656_a(pos, placeState) : (this.validEditable(state, world, pos, facing, stack, player) && facing.func_176740_k().func_176720_b() ? world.func_175656_a(pos, placeState = this.slab.getOpposite(placeState)) : player.func_175151_a(pos, facing, stack) && facing.func_176740_k().func_176722_c() && state.func_177230_c() == this.field_150939_a && this.canBeMerged(state, placeState) && this.doubleSlab(world, pos))) {
                return this.shrinkAndSucceed(world, pos, player, stack);
            }
            return EnumActionResult.PASS;
        }

        private boolean validEditable(IBlockState state, World world, BlockPos pos, EnumFacing facing, ItemStack stack, EntityPlayer player) {
            return state.func_177230_c().func_176200_f((IBlockAccess)world, pos) && player.func_175151_a(pos, facing, stack);
        }

        private boolean canBeMerged(IBlockState state, IBlockState state2) {
            return state != state2 && state != this.slab.getDouble();
        }

        private boolean checkOppositeByFacing(IBlockState state, EnumFacing facing) {
            if (facing == EnumFacing.DOWN) {
                return state.func_177229_b(VARIANT) == SlabVariant.UPPER;
            }
            if (facing == EnumFacing.UP) {
                return state.func_177229_b(VARIANT) == SlabVariant.LOWER;
            }
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
            IBlockState state = this.getByHitY(Minecraft.func_71410_x().field_71476_x.field_72307_f.field_72448_b % 1.0);
            IBlockState current = world.func_180495_p(pos);
            if (current == this.slab.getDouble()) {
                pos = pos.func_177972_a(side);
            }
            current = world.func_180495_p(pos);
            if (state != this.slab.getDouble() && state != current) {
                return true;
            }
            return super.func_179222_a(world, pos, side, player, stack) && world.func_72917_a(((SlabVariant)((Object)state.func_177229_b(VARIANT))).getAABB().func_186670_a(pos), null);
        }

        private boolean canPlaceOnSide(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
            IBlockState state = this.field_150939_a.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, player.func_184586_b(hand).func_77960_j(), (EntityLivingBase)player, hand);
            IBlockState current = world.func_180495_p(pos);
            if (current.func_177230_c() == this.field_150939_a && current != this.slab.getDouble()) {
                return world.func_72917_a(((SlabVariant)((Object)state.func_177229_b(VARIANT))).getAABB().func_186670_a(pos), null);
            }
            return world.func_72917_a(((SlabVariant)((Object)state.func_177229_b(VARIANT))).getAABB().func_186670_a(pos.func_177972_a(side)), null);
        }

        private EnumActionResult shrinkAndSucceed(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
            SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }

        private IBlockState getByHitY(double hitY) {
            if (hitY >= 0.5) {
                return this.field_150939_a.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.UPPER));
            }
            return this.field_150939_a.func_176223_P();
        }

        private boolean doubleSlab(World world, BlockPos pos) {
            return world.func_175656_a(pos, this.slab.getDouble());
        }

        public int func_77647_b(int damage) {
            return damage;
        }
    }

    public static enum SlabVariant implements IPropertyEnum
    {
        LOWER(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)),
        UPPER(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0)),
        DOUBLE(Block.field_185505_j);

        private AxisAlignedBB aabb;

        private SlabVariant(AxisAlignedBB AABB) {
            this.aabb = AABB;
        }

        public AxisAlignedBB getAABB() {
            return this.aabb;
        }

        public ItemStack get() {
            return ItemStack.field_190927_a;
        }
    }
}

