/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IIntake;
import zmaster587.advancedRocketry.api.IMiningDrill;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockRocketMotor;
import zmaster587.advancedRocketry.block.BlockSeat;
import zmaster587.advancedRocketry.entity.EntityStationDeployedRocket;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.block.BlockFullyRotatable;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.ZUtils;

public class TileStationDeployedAssembler
extends TileRocketBuilder {
    private static final int MAX_SIZE = 17;
    private static final int MAX_SIZE_Y = 17;
    private static final int MIN_SIZE = 3;
    private static final int MIN_SIZE_Y = 3;

    @Override
    public AxisAlignedBB getRocketPadBounds(World world, BlockPos pos2) {
        int zSize;
        int xSize;
        int zMin;
        int xMin;
        EnumFacing direction = RotatableBlock.getFront((IBlockState)world.func_180495_p(pos2)).func_176734_d();
        int yCurrent = pos2.func_177956_o();
        int xCurrent = pos2.func_177958_n();
        int zCurrent = pos2.func_177952_p();
        int xMax = xMin = xCurrent;
        int zMax = zMin = zCurrent;
        int yMax = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.UP, (BlockPos)this.func_174877_v().func_177982_a(0, 1, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
        if (direction.func_82601_c() != 0) {
            xSize = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)direction, (BlockPos)pos2.func_177982_a(0, yMax, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
            zMin = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.NORTH, (BlockPos)pos2.func_177982_a(0, 0, -1), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower) + 1;
            zMax = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.SOUTH, (BlockPos)pos2.func_177982_a(0, 0, 1), (int)(17 - zMin), (Block)AdvancedRocketryBlocks.blockStructureTower);
            zSize = zMin + zMax;
            zMin = zCurrent - zMin + 1;
            zMax = zCurrent + zMax;
            if (direction.func_82601_c() > 0) {
                xMax = xCurrent + xSize - 1;
                ++xMin;
            }
            if (direction.func_82601_c() < 0) {
                xMin = xCurrent - xSize + 1;
                --xMax;
            }
        } else {
            zSize = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)direction, (BlockPos)pos2.func_177982_a(0, yMax, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
            xMin = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.WEST, (BlockPos)pos2.func_177982_a(-1, 0, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower) + 1;
            xMax = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.EAST, (BlockPos)pos2.func_177982_a(1, 0, 0), (int)(17 - xMin), (Block)AdvancedRocketryBlocks.blockStructureTower);
            xSize = xMin + xMax;
            xMin = xCurrent - xMin + 1;
            xMax = xCurrent + xMax;
            if (direction.func_82599_e() > 0) {
                zMax = zCurrent + zSize - 1;
                ++zMin;
            }
            if (direction.func_82599_e() < 0) {
                zMin = zCurrent - zSize + 1;
                --zMax;
            }
        }
        if (yMax < 3 || xSize < 3 || zSize < 3) {
            return null;
        }
        return new AxisAlignedBB((double)xMin, (double)yCurrent, (double)zMin, (double)xMax, (double)(yCurrent + yMax - 1), (double)zMax);
    }

    @Override
    public void assembleRocket() {
        StorageChunk storageChunk;
        if (this.bbCache == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.scanRocket(this.field_145850_b, this.func_174877_v(), this.bbCache);
        if (this.status != TileRocketBuilder.ErrorCodes.SUCCESS) {
            return;
        }
        try {
            storageChunk = StorageChunk.cutWorldBB(this.field_145850_b, this.bbCache);
        }
        catch (NegativeArraySizeException e) {
            return;
        }
        EntityStationDeployedRocket rocket = new EntityStationDeployedRocket(this.field_145850_b, storageChunk, this.stats.copy(), this.bbCache.field_72340_a + (this.bbCache.field_72336_d - this.bbCache.field_72340_a) / 2.0 + 0.5, this.func_174877_v().func_177956_o(), this.bbCache.field_72339_c + (this.bbCache.field_72334_f - this.bbCache.field_72339_c) / 2.0 + 0.5);
        rocket.forwardDirection = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v())).func_176734_d();
        rocket.launchDirection = EnumFacing.DOWN;
        for (int x = 0; x < storageChunk.getSizeX(); ++x) {
            for (int y = 0; y < storageChunk.getSizeY(); ++y) {
                for (int z = 0; z < storageChunk.getSizeZ(); ++z) {
                    BlockPos pos3 = new BlockPos(x, y, z);
                    if (!(storageChunk.func_180495_p(pos3).func_177230_c() instanceof BlockRocketMotor)) continue;
                    storageChunk.setBlockState(pos3, storageChunk.func_180495_p(pos3).func_177226_a((IProperty)BlockFullyRotatable.FACING, (Comparable)rocket.forwardDirection));
                }
            }
        }
        this.field_145850_b.func_72838_d((Entity)rocket);
        NBTTagCompound nbtdata = new NBTTagCompound();
        rocket.func_189511_e(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)rocket, 0, nbtdata), (int)rocket.field_70170_p.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)64.0);
        this.stats.reset();
        this.status = TileRocketBuilder.ErrorCodes.UNSCANNED;
        this.func_70296_d();
        for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
            rocket.linkInfrastructure(infrastructure);
        }
    }

    @Override
    public void scanRocket(World world, BlockPos pos2, AxisAlignedBB bb) {
        int thrust = 0;
        int fuelUse = 0;
        int fuel = 0;
        int numBlocks = 0;
        float drillPower = 0.0f;
        this.stats.reset();
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int xCurr = (int)bb.field_72340_a;
        while ((double)xCurr <= bb.field_72336_d) {
            int zCurr = (int)bb.field_72339_c;
            while ((double)zCurr <= bb.field_72334_f) {
                int yCurr = (int)bb.field_72338_b;
                while ((double)yCurr <= bb.field_72337_e) {
                    BlockPos currPos = new BlockPos(xCurr, yCurr, zCurr);
                    if (!world.func_175623_d(currPos)) {
                        if (xCurr < actualMinX) {
                            actualMinX = xCurr;
                        }
                        if (yCurr < actualMinY) {
                            actualMinY = yCurr;
                        }
                        if (zCurr < actualMinZ) {
                            actualMinZ = zCurr;
                        }
                        if (xCurr > actualMaxX) {
                            actualMaxX = xCurr;
                        }
                        if (yCurr > actualMaxY) {
                            actualMaxY = yCurr;
                        }
                        if (zCurr > actualMaxZ) {
                            actualMaxZ = zCurr;
                        }
                    }
                    ++yCurr;
                }
                ++zCurr;
            }
            ++xCurr;
        }
        boolean hasSatellite = false;
        boolean hasGuidance = false;
        int fluidCapacity = 0;
        if (this.verifyScan(bb, world)) {
            int yCurr = (int)bb.field_72338_b;
            while ((double)yCurr <= bb.field_72337_e) {
                int xCurr2 = (int)bb.field_72340_a;
                while ((double)xCurr2 <= bb.field_72336_d) {
                    int zCurr = (int)bb.field_72339_c;
                    while ((double)zCurr <= bb.field_72334_f) {
                        BlockPos currPos = new BlockPos(xCurr2, yCurr, zCurr);
                        if (!world.func_175623_d(currPos)) {
                            TileEntity tile;
                            IBlockState state = world.func_180495_p(currPos);
                            Block block = state.func_177230_c();
                            ++numBlocks;
                            if (block instanceof IRocketEngine) {
                                thrust += ((IRocketEngine)block).getThrust(world, currPos);
                                fuelUse += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                this.stats.addEngineLocation((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f, yCurr - actualMinY, (float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f);
                            }
                            if (block instanceof IFuelTank) {
                                fuel += ((IFuelTank)block).getMaxFill(world, currPos, state);
                            }
                            if (block instanceof BlockSeat) {
                                if (this.stats.hasSeat()) {
                                    this.stats.addPassengerSeat((int)((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f), yCurr - actualMinY, (int)((float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f));
                                } else {
                                    this.stats.setSeatLocation((int)((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f), yCurr - actualMinY, (int)((float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f));
                                }
                            }
                            if (block instanceof IMiningDrill) {
                                drillPower += ((IMiningDrill)block).getMiningSpeed(world, currPos);
                            }
                            if (block instanceof IIntake) {
                                this.stats.setStatTag("intakePower", (Integer)this.stats.getStatTag("intakePower") + ((IIntake)block).getIntakeAmt(state));
                            }
                            if ((tile = world.func_175625_s(currPos)) instanceof TileSatelliteHatch) {
                                hasSatellite = true;
                            }
                            if (tile instanceof TileGuidanceComputer) {
                                hasGuidance = true;
                            }
                            if (tile instanceof IFluidHandler) {
                                for (IFluidTankProperties info : ((IFluidHandler)tile).getTankProperties()) {
                                    fluidCapacity += info.getCapacity();
                                }
                            }
                        }
                        ++zCurr;
                    }
                    ++xCurr2;
                }
                ++yCurr;
            }
            this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID, fuelUse);
            this.stats.setWeight(numBlocks);
            this.stats.setThrust(thrust);
            this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID, fuel);
            this.stats.setDrillingPower(drillPower);
            this.stats.setStatTag("liquidCapacity", fluidCapacity);
            this.status = (float)this.getFuel() < this.getNeededFuel() * (float)(1 + fluidCapacity / 1000) ? TileRocketBuilder.ErrorCodes.NOFUEL : ((float)this.getThrust() < this.getNeededThrust() ? TileRocketBuilder.ErrorCodes.NOENGINES : TileRocketBuilder.ErrorCodes.SUCCESS);
        }
    }

    @Override
    public float getNeededFuel() {
        return this.getAcceleration() > 0.0f ? (float)this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID) : 0.0f;
    }

    @Override
    protected boolean verifyScan(AxisAlignedBB bb, World world) {
        return true;
    }
}

