/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.recipe;

import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.drawing.Size;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.elements.ElementImage;
import gigaherz.guidebook.guidebook.elements.ElementStack;
import gigaherz.guidebook.guidebook.recipe.RecipeProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

class CraftingRecipeProvider
extends RecipeProvider {
    private static final int[] INPUT_SLOT_BASE_X = new int[]{4, 13};
    private static final int[] INPUT_SLOT_BASE_Y = new int[]{3, 3};
    private static final int INPUT_SLOT_OFFSET = 19;
    private static final int[] OUTPUT_SLOT_X = new int[]{80, 70};
    private static final int[] OUTPUT_SLOT_Y = new int[]{22, 13};
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("gbook", "gui/recipe_backgrounds");
    private static final int[] BACKGROUND_U = new int[]{0, 0};
    private static final int[] BACKGROUND_V = new int[]{0, 60};
    private static final int[] BACKGROUND_W = new int[]{100, 100};
    private static final int[] BACKGROUND_H = new int[]{60, 41};
    private static final int[] HEIGHT = BACKGROUND_H;
    private static final int LEFT_OFFSET = 38;

    CraftingRecipeProvider() {
    }

    @Override
    @Nullable
    public RecipeProvider.ProvidedComponents provideRecipeComponents(@Nonnull ItemStack targetOutput, int recipeIndex) {
        return this.provideCraftingRecipeComponents(this.getRecipesByOutput(targetOutput, recipeIndex));
    }

    @Override
    @Nullable
    public RecipeProvider.ProvidedComponents provideRecipeComponents(@Nonnull ResourceLocation recipeKey) {
        return this.provideCraftingRecipeComponents(this.getRecipeByName(recipeKey));
    }

    @Nullable
    private IRecipe getRecipeByName(ResourceLocation name) {
        return (IRecipe)ForgeRegistries.RECIPES.getValue(name);
    }

    @Nullable
    private IRecipe getRecipesByOutput(@Nonnull ItemStack targetOutput, int recipeIndex) {
        return ForgeRegistries.RECIPES.getValuesCollection().stream().filter(r -> !r.func_192399_d() && ItemStack.func_185132_d((ItemStack)targetOutput, (ItemStack)r.func_77571_b())).skip(recipeIndex).findFirst().orElse(null);
    }

    @Nullable
    private RecipeProvider.ProvidedComponents provideCraftingRecipeComponents(@Nullable IRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        int constantIndex = recipe.func_192400_c().size() <= 4 ? 1 : 0;
        ArrayList<ElementStack> stackComponents = new ArrayList<ElementStack>();
        VisualElement additionalRenderer = new VisualElement(new Size(), 0, 0.0f, 0){

            @Override
            public void draw(IBookGraphics nav) {
            }
        };
        int gridWidth = constantIndex == 0 ? 3 : 2;
        NonNullList ingredients = recipe.func_192400_c();
        for (int i = 0; i < ingredients.size(); ++i) {
            ElementStack inputSlot = new ElementStack();
            ItemStack[] matching = ((Ingredient)ingredients.get(i)).func_193365_a();
            if (matching.length == 0) continue;
            for (int j = 0; j < matching.length; ++j) {
                inputSlot.stacks.add((Object)matching[j].func_77946_l());
            }
            int posX = i % gridWidth;
            int posY = i / gridWidth;
            inputSlot.x = INPUT_SLOT_BASE_X[constantIndex] + posX * 19 + 38;
            inputSlot.y = INPUT_SLOT_BASE_Y[constantIndex] + posY * 19;
            stackComponents.add(inputSlot);
        }
        ElementStack outputSlot = new ElementStack();
        stackComponents.add(outputSlot);
        List<ItemStack> stackList = RecipeProvider.copyAndExpand(recipe.func_77571_b());
        outputSlot.stacks.addAll(stackList);
        outputSlot.x = OUTPUT_SLOT_X[constantIndex] + 38;
        outputSlot.y = OUTPUT_SLOT_Y[constantIndex];
        ElementImage background = new ElementImage();
        background.textureLocation = BACKGROUND_TEXTURE;
        background.x = 38;
        background.y = 0;
        background.tx = BACKGROUND_U[constantIndex];
        background.ty = BACKGROUND_V[constantIndex];
        background.w = BACKGROUND_W[constantIndex];
        background.h = BACKGROUND_H[constantIndex];
        int height = HEIGHT[constantIndex];
        ElementStack[] components = new ElementStack[stackComponents.size()];
        stackComponents.toArray(components);
        return new RecipeProvider.ProvidedComponents(height, components, background, additionalRenderer);
    }
}

