/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.drawing;

import com.google.common.collect.Sets;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.SectionRef;
import gigaherz.guidebook.guidebook.drawing.Size;
import gigaherz.guidebook.guidebook.drawing.VisualText;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class VisualLink
extends VisualText {
    private static final Set<String> PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    public String textTarget;
    public String textAction;
    public SectionRef target;
    public int colorHover = -8926106;
    public SharedHoverContext hoverContext = new SharedHoverContext();

    public VisualLink(String text, Size size, int positionMode, float baseline, int verticalAlign, float scale) {
        super(text, size, positionMode, baseline, verticalAlign, scale);
    }

    @Override
    public void draw(IBookGraphics nav) {
        nav.addString(this.position.x, this.position.y, this.text, this.hoverContext.isHovering ? this.colorHover : this.color, this.scale);
    }

    @Override
    public boolean wantsHover() {
        return true;
    }

    @Override
    public void mouseOver(IBookGraphics nav, int x, int y) {
        this.hoverContext.isHovering = true;
    }

    @Override
    public void mouseOut(IBookGraphics nav, int x, int y) {
        this.hoverContext.isHovering = false;
    }

    @Override
    public void click(IBookGraphics nav) {
        if (this.textTarget != null) {
            switch (this.textAction) {
                case "openUrl": {
                    this.clickWeb(nav);
                    break;
                }
                case "copyText": {
                    this.clickCopyToClipboard(nav);
                }
            }
        }
        if (this.target != null) {
            nav.navigateTo(this.target);
        }
    }

    public void clickCopyToClipboard(IBookGraphics nav) {
        final GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
            if (result) {
                GuiScreen.func_146275_d((String)this.textTarget);
                mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("text.copyToClipboard.success", new Object[0]));
            }
            mc.func_147108_a(parent);
        }, I18n.func_135052_a((String)"text.copyToClipboard.line1", (Object[])new Object[0]), I18n.func_135052_a((String)"text.copyToClipboard.line2", (Object[])new Object[0]), 0){

            public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                parent.func_73863_a(-1, -1, partialTicks);
                super.func_73863_a(mouseX, mouseY, partialTicks);
            }
        });
    }

    public void clickWeb(IBookGraphics nav) {
        GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74359_p) {
            return;
        }
        try {
            URI uri = new URI(this.textTarget);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(this.textTarget, "Missing protocol");
            }
            if (!PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(this.textTarget, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            if (mc.field_71474_y.field_74358_q) {
                ReflectionHelper.setPrivateValue(GuiScreen.class, (Object)parent, (Object)uri, (String[])new String[]{"field_175286_t", "clickedLinkURI"});
                mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)parent, this.textTarget, 31102009, false));
            } else {
                VisualLink.openWebLink(uri);
            }
        }
        catch (URISyntaxException urisyntaxexception) {
            GuidebookMod.logger.error("Can't open url {}", (Object)this.textTarget, (Object)urisyntaxexception);
        }
    }

    private static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            GuidebookMod.logger.error("Can't open url {}", (Object)url, (Object)throwable1);
        }
    }

    public static class SharedHoverContext {
        private boolean isHovering;
    }
}

