/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile;

import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.network.tile.TileDataService;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public final class TileDataServiceContainer {
    private static final Map<ResourceLocation, ITileDataService> SERVICE_MAP = new HashMap<ResourceLocation, ITileDataService>();
    private static final Int2ObjectOpenHashMap<ITileDataService> SERVICE_ID_MAP = new Int2ObjectOpenHashMap();
    private static int NEXT_ID;

    public static ITileDataService register(ResourceLocation location, IPacketService packetService) {
        if (SERVICE_MAP.get(location) != null) {
            throw new IllegalStateException("Tile data service already registered for id: " + location);
        }
        TileDataService service = new TileDataService(NEXT_ID, packetService);
        SERVICE_MAP.put(location, service);
        SERVICE_ID_MAP.put(NEXT_ID, (Object)service);
        ++NEXT_ID;
        return service;
    }

    @Nullable
    public static ITileDataService find(ResourceLocation location) {
        return SERVICE_MAP.get(location);
    }

    @Nullable
    public static ITileDataService find(int serviceId) {
        return (ITileDataService)SERVICE_ID_MAP.get(serviceId);
    }

    @SubscribeEvent
    public static void on(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (ITileDataService service : SERVICE_MAP.values()) {
                service.update();
            }
        }
    }
}

