/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.gui.controls.GuiDirectionIndicator;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.packet.LittleBedPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.LittleSlidingDoor;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleBed
extends LittleStructure {
    public EntityLivingBase sleepingPlayer = null;
    @SideOnly(value=Side.CLIENT)
    public Vec3d playerPostion;
    public EnumFacing direction;
    @SideOnly(value=Side.CLIENT)
    public boolean hasBeenActivated;
    public static Method setSize = ReflectionHelper.findMethod(Entity.class, (String)"setSize", (String)"func_70105_a", (Class[])new Class[]{Float.TYPE, Float.TYPE});
    public static Field sleeping = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"sleeping", "field_71083_bS"});
    public static Field sleepTimer = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"sleepTimer", "field_71076_b"});
    public static Field littleBed = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"littleBed"});

    public LittleBed(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.direction = EnumFacing.func_176731_b((int)nbt.func_74762_e("direction"));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("direction", this.direction.func_176736_b());
    }

    @Override
    public boolean isBed(IBlockAccess world, BlockPos pos, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getBedOrientationInDegrees(EntityPlayer player) {
        IBlockState state;
        try {
            LittleStructure bed = (LittleStructure)littleBed.get(player);
            if (bed instanceof LittleBed) {
                switch (((LittleBed)bed).direction) {
                    case SOUTH: {
                        return 90.0f;
                    }
                    case WEST: {
                        return 0.0f;
                    }
                    case NORTH: {
                        return 270.0f;
                    }
                    case EAST: {
                        return 180.0f;
                    }
                }
                return 0.0f;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        IBlockState iBlockState = state = player.field_71081_bT == null ? null : player.field_70170_p.func_180495_p(player.field_71081_bT);
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)player.field_70170_p, player.field_71081_bT, (Entity)player)) {
            EnumFacing enumfacing = state.func_177230_c().getBedDirection(state, (IBlockAccess)player.field_70170_p, player.field_71081_bT);
            switch (enumfacing) {
                case SOUTH: {
                    return 90.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    public EntityPlayer.SleepResult trySleep(EntityPlayer player, Vec3d highest) {
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (!player.field_70170_p.field_73011_w.func_76569_d()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            }
            if (player.field_70170_p.func_72935_r()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = player.field_70170_p.func_72872_a(EntityMob.class, new AxisAlignedBB(highest.field_72450_a - 8.0, highest.field_72448_b - 5.0, highest.field_72449_c - 8.0, highest.field_72450_a + 8.0, highest.field_72448_b + 5.0, highest.field_72449_c + 8.0));
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        if (player.field_70170_p.field_72995_K) {
            this.playerPostion = highest;
        }
        this.sleepingPlayer = player;
        try {
            littleBed.set(player, this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        try {
            setSize.invoke((Object)player, Float.valueOf(0.2f), Float.valueOf(0.2f));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        float f1 = 0.5f + (float)this.direction.func_82601_c() * 0.8f;
        float f = 0.5f + (float)this.direction.func_82599_e() * 0.8f;
        player.field_71079_bU = -1.8f * (float)this.direction.func_82601_c();
        player.field_71089_bV = -1.8f * (float)this.direction.func_82599_e();
        player.func_70107_b((double)((float)highest.field_72450_a - 0.5f + f1), (double)((float)highest.field_72448_b), (double)((float)highest.field_72449_c - 0.5f + f));
        try {
            sleeping.setBoolean(player, true);
            sleepTimer.setInt(player, 0);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        player.field_71081_bT = this.getMainTile().te.func_174877_v();
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72854_c();
        }
        return EntityPlayer.SleepResult.OK;
    }

    @Override
    public void onLittleTileDestroy() {
        super.onLittleTileDestroy();
        if (this.sleepingPlayer != null) {
            try {
                littleBed.set(this.sleepingPlayer, null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setBedDirection(Entity player) {
        if (player instanceof EntityPlayer) {
            try {
                LittleStructure bed = (LittleStructure)littleBed.get(player);
                if (bed instanceof LittleBed) {
                    int i = ((LittleBed)bed).direction.func_176736_b();
                    GlStateManager.func_179114_b((float)(i * 90), (float)0.0f, (float)1.0f, (float)0.0f);
                    if (player == Minecraft.func_71410_x().field_71439_g) {
                        double height = 0.2;
                        double forward = 0.0;
                        GlStateManager.func_179137_b((double)((double)((LittleBed)bed).direction.func_176730_m().func_177958_n() * forward), (double)height, (double)((double)((LittleBed)bed).direction.func_176730_m().func_177952_p() * forward));
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (!this.hasLoaded() || !SpecialServerConfig.enableBed) {
            return false;
        }
        if (world.field_72995_K) {
            this.hasBeenActivated = true;
            return true;
        }
        if (world.field_73011_w.func_76567_e() && world.func_180494_b(pos) != Biomes.field_76778_j) {
            Vec3d vec = this.getHighestCenterVec();
            if (this.sleepingPlayer != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                return true;
            }
            EntityPlayer.SleepResult enumstatus = this.trySleep(player, vec);
            if (enumstatus == EntityPlayer.SleepResult.OK) {
                player.func_71029_a(StatList.field_188064_ad);
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleBedPacket(new LittleTileIdentifierAbsolute(this.getMainTile())), (EntityPlayerMP)((EntityPlayerMP)player));
                PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleBedPacket(new LittleTileIdentifierAbsolute(this.getMainTile()), player), (EntityPlayerMP)((EntityPlayerMP)player));
                return true;
            }
            if (enumstatus == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
            } else if (enumstatus == EntityPlayer.SleepResult.NOT_SAFE) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
            }
            return true;
        }
        return true;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        if (axis == this.direction.func_176740_k()) {
            this.direction = this.direction.func_176734_d();
        }
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, Rotation rotation, LittleTileVec doubledCenter) {
        this.direction = RotationUtils.rotate((EnumFacing)this.direction, (Rotation)rotation);
    }

    public static class LittleBedParser
    extends LittleStructureGuiParser {
        public LittleBedParser(GuiParent parent) {
            super(parent);
        }

        @SideOnly(value=Side.CLIENT)
        @CustomEventSubscribe
        public void buttonClicked(GuiControlClickEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)this.parent.get("relativeDirection");
            EnumFacing direction = EnumFacing.func_176731_b((int)((GuiStateButton)this.parent.get("direction")).getState());
            LittleSlidingDoor.LittleSlidingDoorParser.updateDirection(viewer, direction.func_176734_d(), relativeDirection);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(ItemStack stack, LittleStructure structure) {
            GuiTileViewer tile = new GuiTileViewer("tileviewer", 0, 0, 100, 100, LittleGridContext.get(stack.func_77978_p()));
            tile.setViewDirection(EnumFacing.UP);
            this.parent.addControl((GuiControl)tile);
            LittleTileSize size = LittleTilePreview.getSize(stack);
            int index = EnumFacing.EAST.func_176736_b();
            if (size.sizeX < size.sizeZ) {
                index = EnumFacing.SOUTH.func_176736_b();
            }
            if (structure instanceof LittleBed) {
                index = ((LittleBed)structure).direction.func_176736_b();
            }
            this.parent.addControl((GuiControl)new GuiStateButton("direction", index, 110, 0, 37, RotationUtils.getHorizontalFacingNames()));
            GuiDirectionIndicator relativeDirection = new GuiDirectionIndicator("relativeDirection", 155, 0, EnumFacing.UP);
            this.parent.addControl((GuiControl)relativeDirection);
            LittleSlidingDoor.LittleSlidingDoorParser.updateDirection(tile, EnumFacing.func_176731_b((int)index).func_176734_d(), relativeDirection);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleBed parseStructure(ItemStack stack) {
            EnumFacing direction = EnumFacing.func_176731_b((int)((GuiStateButton)this.parent.get("direction")).getState());
            LittleBed bed = this.createStructure(LittleBed.class);
            bed.direction = direction;
            return bed;
        }
    }
}

