/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxCategory;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.FakeWorld;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.gui.controls.GuiAnimationViewer;
import com.creativemd.littletiles.common.gui.controls.IAnimationControl;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SubGuiRecipe
extends SubGuiConfigure {
    public LittleStructure structure;
    public LittleStructureGuiParser parser;
    public PairList<String, PairList<String, Class<? extends LittleStructureGuiParser>>> craftables;
    protected LoadingThread loadingThread = new LoadingThread();
    public boolean loaded = false;
    public EntityAnimation animation = null;
    public LittleTileBox entireBox;
    public LittleGridContext context;
    public AxisAlignedBB box;
    public LittlePreviews previews;

    public SubGuiRecipe(ItemStack stack) {
        super(350, 200, stack);
    }

    public void onLoaded(GuiParent parent, EntityAnimation animation, LittleTileBox entireBox, LittleGridContext context, AxisAlignedBB box) {
        for (GuiControl control : parent.controls) {
            if (control instanceof IAnimationControl) {
                ((IAnimationControl)control).onLoaded(animation, entireBox, context, box, this.previews);
            }
            if (!(control instanceof GuiParent)) continue;
            this.onLoaded((GuiParent)control, animation, entireBox, context, box);
        }
        if (this.parser != null) {
            this.parser.onLoaded(animation, entireBox, context, box);
        }
    }

    public void onTick() {
        super.onTick();
        if (this.loadingThread == null && !this.loaded) {
            this.onLoaded((GuiParent)this, this.animation, this.entireBox, this.context, this.box);
            this.loaded = true;
        }
    }

    @Override
    public void saveConfiguration() {
    }

    public void createControls() {
        this.controls.add(new GuiButton("clear", SubGuiRecipe.translate((String)"selection.clear"), 105, 176, 38){

            public void onClicked(int x, int y, int button) {
                SubGuiRecipe.this.openYesNoDialog(1.translate((String)"selection.dialog.clear"));
            }
        });
        PairList noneCategory = new PairList();
        noneCategory.add((Object)"structure.none.name", null);
        this.craftables = new PairList(LittleStructureRegistry.getCraftables());
        this.craftables.add(0, new Pair((Object)"", (Object)noneCategory));
        GuiComboBoxCategory comboBox = new GuiComboBoxCategory("types", 0, 5, 80, this.craftables);
        LittlePreviews previews = LittleTilePreview.getPreview(this.stack);
        LittleStructure structure = previews.getStructure();
        if (structure != null) {
            this.structure = structure;
            int index = 0;
            for (Pair category : this.craftables) {
                int currentIndex = ((PairList)category.value).indexOfKey((Object)("structure." + structure.type.id + ".name"));
                if (currentIndex != -1) {
                    comboBox.select(currentIndex + index);
                    break;
                }
                index += ((PairList)category.value).size();
            }
        }
        int size = previews.totalSize();
        this.controls.add(new GuiLabel("tiles", previews.totalSize() + " " + SubGuiRecipe.translate((String)(size == 1 ? "selection.structure.tile" : "selection.structure.tiles")), 208, 158));
        this.controls.add(new GuiAnimationViewer("renderer", 208, 30, 136, 135));
        this.controls.add(new GuiPanel("panel", 0, 30, 200, 135));
        this.controls.add(comboBox);
        this.controls.add(new GuiButton("save", 150, 176, 40){

            public void onClicked(int x, int y, int button) {
                if (SubGuiRecipe.this.parser != null) {
                    GuiTextfield textfield = (GuiTextfield)SubGuiRecipe.this.get("name");
                    LittleStructure structure = SubGuiRecipe.this.parser.parseStructure(SubGuiRecipe.this.stack);
                    if (structure != null) {
                        structure.name = textfield.text.isEmpty() ? null : textfield.text;
                        NBTTagCompound structureNBT = new NBTTagCompound();
                        structure.writeToNBT(structureNBT);
                        SubGuiRecipe.this.stack.func_77978_p().func_74782_a("structure", (NBTBase)structureNBT);
                    } else {
                        SubGuiRecipe.this.stack.func_77978_p().func_82580_o("structure");
                    }
                } else {
                    SubGuiRecipe.this.stack.func_77978_p().func_82580_o("structure");
                }
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("set_structure", true);
                nbt.func_74782_a("stack", (NBTBase)SubGuiRecipe.this.stack.func_77978_p());
                SubGuiRecipe.this.sendPacketToServer(nbt);
                SubGuiRecipe.this.closeGui();
            }
        });
        this.controls.add(new GuiTextfield("name", structure != null && structure.name != null ? structure.name : "", 2, 176, 95, 14).setCustomTooltip(new String[]{SubGuiRecipe.translate((String)"selection.structure.name")}));
        this.onChanged();
    }

    public void onChanged() {
        LittleStructure saved;
        GuiPanel panel = (GuiPanel)this.get("panel");
        panel.controls.clear();
        GuiComboBoxCategory types = (GuiComboBoxCategory)this.get("types");
        Pair selected = types.getSelected();
        if (this.parser != null) {
            this.removeListener(this.parser);
        }
        if ((saved = this.structure) != null && !((String)selected.key).equals("structure." + saved.type.id + ".name")) {
            saved = null;
        }
        this.parser = LittleStructureRegistry.getParser((GuiParent)panel, (Class)selected.value);
        if (this.parser != null) {
            this.parser.createControls(this.stack, saved);
            panel.refreshControls();
            this.addListener(this.parser);
            if (this.loaded) {
                this.onLoaded((GuiParent)panel, this.animation, this.entireBox, this.context, this.box);
            }
        } else {
            this.parser = null;
        }
        this.get("name").setEnabled(this.parser != null);
    }

    @CustomEventSubscribe
    public void onComboChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"types"})) {
            this.onChanged();
        }
    }

    public void onDialogClosed(String text, String[] buttons, String clicked) {
        if (clicked.equalsIgnoreCase("yes")) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("clear_content", true);
            this.sendPacketToServer(nbt);
        }
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
        this.stack.func_77982_d(nbt);
    }

    public class LoadingThread
    extends Thread {
        public LoadingThread() {
            this.start();
        }

        @Override
        public void run() {
            ILittleTile iTile = PlacementHelper.getLittleInterface(SubGuiRecipe.this.stack);
            if (SubGuiRecipe.this.stack.func_77973_b() instanceof ItemRecipe || iTile != null && iTile.hasLittlePreview(SubGuiRecipe.this.stack)) {
                SubGuiRecipe.this.previews = iTile != null ? iTile.getLittlePreview(SubGuiRecipe.this.stack) : LittleTilePreview.getPreview(SubGuiRecipe.this.stack);
                BlockPos pos = new BlockPos(0, 75, 0);
                FakeWorld fakeWorld = FakeWorld.createFakeWorld((String)"animationViewer", (boolean)true);
                ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
                SubGuiRecipe.this.previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
                HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(SubGuiRecipe.this.previews.context, placePreviews, pos);
                ArrayList<TileEntityLittleTiles> blocks = new ArrayList<TileEntityLittleTiles>();
                LittleActionPlaceStack.placeTilesWithoutPlayer((World)fakeWorld, SubGuiRecipe.this.previews.context, splitted, SubGuiRecipe.this.previews.getStructure(), PlacementMode.all, pos, null, null, null, null);
                for (TileEntity te : fakeWorld.field_147482_g) {
                    if (!(te instanceof TileEntityLittleTiles)) continue;
                    blocks.add((TileEntityLittleTiles)te);
                }
                SubGuiRecipe.this.entireBox = SubGuiRecipe.this.previews.getSurroundingBox();
                SubGuiRecipe.this.context = SubGuiRecipe.this.previews.context;
                SubGuiRecipe.this.box = SubGuiRecipe.this.entireBox.getBox(SubGuiRecipe.this.context);
                SubGuiRecipe.this.animation = new EntityAnimation((World)fakeWorld, (CreativeWorld)fakeWorld, (EntityAnimationController)new EntityAnimationController(){

                    @Override
                    protected void writeToNBTExtra(NBTTagCompound nbt) {
                    }

                    @Override
                    protected void readFromNBT(NBTTagCompound nbt) {
                    }

                    @Override
                    public boolean onRightClick() {
                        return false;
                    }
                }.addStateAndSelect(new AnimationState("nothing", null, null)), pos, UUID.randomUUID(), new StructureAbsolute(pos, SubGuiRecipe.this.entireBox, SubGuiRecipe.this.previews.context)){

                    @Override
                    public boolean shouldAddDoor() {
                        return false;
                    }
                };
            }
            SubGuiRecipe.this.loadingThread = null;
        }
    }
}

