/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.command;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.events.LittleDoorHandler;
import com.creativemd.littletiles.common.packet.LittleEntityInteractPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.LittleDoorBase;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class OpenCommand
extends CommandBase {
    public String func_71517_b() {
        return "lt-open";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.open.usage";
    }

    protected boolean checkStructureName(LittleStructure structure, String[] args) {
        if (args.length > 3) {
            for (int i = 3; i < args.length; ++i) {
                if (structure.name == null || !structure.name.equalsIgnoreCase(args[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException("commands.open.usage", new Object[0]);
        }
        BlockPos blockpos = OpenCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
        World world = sender.func_130014_f_();
        for (EntityAnimation animation : LittleDoorHandler.server.findDoors(world, blockpos)) {
            LittleStructure structure = animation.getParentStructure();
            if (!(structure instanceof LittleDoorBase) || !this.checkStructureName(structure, args) || !animation.onRightClick(null)) continue;
            PacketHandler.sendPacketToPlayers((CreativeCorePacket)new LittleEntityInteractPacket(animation.func_110124_au()), (Iterable)((WorldServer)world).func_73039_n().getTrackingPlayers((Entity)animation));
        }
        TileEntity tileEntity = world.func_175625_s(blockpos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            ArrayList<LittleDoorBase> doors = new ArrayList<LittleDoorBase>();
            for (LittleTile tile : ((TileEntityLittleTiles)tileEntity).getTiles()) {
                LittleStructure structure;
                if (!tile.isConnectedToStructure() || !((structure = tile.connection.getStructure(tile.te.func_145831_w())) instanceof LittleDoorBase) || !this.checkStructureName(structure, args) || doors.contains(structure)) continue;
                if (structure.hasLoaded()) {
                    doors.add((LittleDoorBase)structure);
                    continue;
                }
                OpenCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.open.notloaded", (Object[])new Object[0]);
            }
            for (LittleDoorBase door : doors) {
                door.activate(world, null, blockpos, null);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 0 && args.length <= 3) {
            return OpenCommand.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
        }
        return Collections.emptyList();
    }
}

