/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.MarkMode;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ILittleTile {
    public boolean hasLittlePreview(ItemStack var1);

    public LittlePreviews getLittlePreview(ItemStack var1);

    default public LittlePreviews getLittlePreview(ItemStack stack, boolean allowLowResolution, boolean marked) {
        return this.getLittlePreview(stack);
    }

    public void saveLittlePreview(ItemStack var1, LittlePreviews var2);

    default public void rotateLittlePreview(EntityPlayer player, ItemStack stack, Rotation rotation) {
        LittlePreviews previews = this.getLittlePreview(stack, false, false);
        if (previews.isEmpty()) {
            return;
        }
        previews.rotatePreviews(player.field_70170_p, player, stack, rotation, previews.context.rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    default public void flipLittlePreview(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis) {
        LittlePreviews previews = this.getLittlePreview(stack, false, false);
        if (previews.isEmpty()) {
            return;
        }
        previews.flipPreviews(player.field_70170_p, player, stack, axis, previews.context.rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    default public LittleGridContext getPreviewsContext(ItemStack stack) {
        if (stack.func_77942_o()) {
            return LittleGridContext.get(stack.func_77978_p());
        }
        return LittleGridContext.get();
    }

    @SideOnly(value=Side.CLIENT)
    default public LittleGridContext getPositionContext(ItemStack stack) {
        return LittleGridContext.get();
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean onRightClick(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public void onDeselect(EntityPlayer player, ItemStack stack) {
    }

    public boolean containsIngredients(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    default public void onClickAir(EntityPlayer player, ItemStack stack) {
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean onClickBlock(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean onMouseWheelClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public float getPreviewAlphaFactor() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean shouldCache() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public void tickPreview(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
    }

    default public PlacementMode getPlacementMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return PlacementMode.getModeOrDefault(stack.func_77978_p().func_74779_i("mode"));
        }
        return PlacementMode.getDefault();
    }

    @SideOnly(value=Side.CLIENT)
    default public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return null;
    }

    default public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    default public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return null;
    }

    default public SubContainerConfigure getConfigureContainerAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    default public MarkMode onMark(EntityPlayer player, ItemStack stack) {
        return new MarkMode();
    }

    default public boolean snapToGridByDefault() {
        return false;
    }

    default public LittleTileSize getCachedSize(ItemStack stack) {
        return null;
    }

    default public LittleTileVec getCachedOffset(ItemStack stack) {
        return null;
    }
}

