/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionDestroy;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.selection.selector.TileSelector;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionDestroyBoxes
extends LittleActionBoxes {
    public List<LittleActionDestroy.StructurePreview> destroyedStructures;
    public LittleAbsolutePreviews previews;
    public boolean doneSomething;

    public LittleActionDestroyBoxes(LittleBoxes boxes) {
        super(boxes);
    }

    public LittleActionDestroyBoxes() {
    }

    private boolean containsStructure(LittleStructure structure) {
        for (LittleActionDestroy.StructurePreview structurePreview : this.destroyedStructures) {
            if (structurePreview.structure != structure) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSkipTile(LittleTile tile) {
        return false;
    }

    public Ingredients action(EntityPlayer player, TileEntityLittleTiles te, List<LittleTileBox> boxes, boolean simulate, LittleGridContext context) {
        this.doneSomething = false;
        if (this.previews == null) {
            this.previews = new LittleAbsolutePreviews(te.func_174877_v(), context);
        }
        Ingredients ingredients = new Ingredients();
        for (LittleTile tile : te.getTiles()) {
            if (this.shouldSkipTile(tile)) continue;
            LittleTileBox intersecting = null;
            boolean intersects = false;
            for (int j = 0; j < boxes.size(); ++j) {
                if (!tile.intersectsWith(boxes.get(j))) continue;
                intersects = true;
                intersecting = boxes.get(j);
                break;
            }
            if (!intersects) continue;
            this.doneSomething = true;
            if (!tile.isChildOfStructure() && tile.canBeSplitted() && !tile.equalsBox(intersecting)) {
                double volume = 0.0;
                LittleTilePreview preview = tile.getPreviewTile();
                ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                List<LittleTileBox> newBoxes = tile.cutOut(boxes, cutout);
                if (newBoxes != null) {
                    if (!simulate) {
                        for (int i = 0; i < newBoxes.size(); ++i) {
                            LittleTile newTile = tile.copy();
                            newTile.box = newBoxes.get(i);
                            newTile.place();
                        }
                        tile.destroy();
                    }
                    for (int l = 0; l < cutout.size(); ++l) {
                        volume += ((LittleTileBox)cutout.get(l)).getPercentVolume(context);
                        if (simulate) continue;
                        LittleTilePreview preview2 = preview.copy();
                        preview2.box = ((LittleTileBox)cutout.get(l)).copy();
                        this.previews.addPreview(te.func_174877_v(), preview2, te.getContext());
                    }
                }
                if (!(volume > 0.0)) continue;
                ingredients.addPreview(preview, volume);
                continue;
            }
            if (!tile.isChildOfStructure()) {
                ingredients.addPreview(tile.getContext(), tile.getPreviewTile());
            }
            if (simulate) continue;
            if (tile.isChildOfStructure()) {
                LittleStructure structure;
                if (!tile.isConnectedToStructure() || !(structure = tile.connection.getStructure(te.func_145831_w())).hasLoaded() || this.containsStructure(structure)) continue;
                this.destroyedStructures.add(new LittleActionDestroy.StructurePreview(structure));
                ItemStack drop = structure.getStructureDrop();
                if (LittleActionDestroyBoxes.needIngredients(player) && !player.field_70170_p.field_72995_K && !InventoryUtils.addItemStackToInventory((IInventory)player.field_71071_by, (ItemStack)drop)) {
                    WorldUtils.dropItem((World)player.field_70170_p, (ItemStack)drop, (BlockPos)tile.te.func_174877_v());
                }
                tile.destroy();
                continue;
            }
            this.previews.addTile(tile);
            tile.destroy();
        }
        return ingredients;
    }

    @Override
    public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state, List<LittleTileBox> boxes, LittleGridContext context) throws LittleActionException {
        TileEntityLittleTiles tileEntity = LittleActionDestroyBoxes.loadTe(player, world, pos, true);
        if (tileEntity instanceof TileEntityLittleTiles) {
            if (!world.field_72995_K) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, tileEntity.func_174877_v(), tileEntity.getBlockTileState(), player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    LittleActionDestroyBoxes.sendBlockResetToClient((EntityPlayerMP)player, pos, tileEntity);
                    return;
                }
            }
            tileEntity.ensureMinContext(context);
            if (context != tileEntity.getContext()) {
                for (LittleTileBox box : boxes) {
                    box.convertTo(context, tileEntity.getContext());
                }
                context = tileEntity.getContext();
            }
            if (LittleActionDestroyBoxes.addIngredients(player, this.action(player, tileEntity, boxes, true, context))) {
                this.action(player, tileEntity, boxes, false, context);
            }
            tileEntity.combineTiles();
            if (!this.doneSomething) {
                tileEntity.convertBlockToVanilla();
            }
        }
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        this.destroyedStructures = new ArrayList<LittleActionDestroy.StructurePreview>();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        boolean additionalPreviews = this.previews != null && this.previews.size() > 0;
        LittleAction[] actions = new LittleAction[(additionalPreviews ? 1 : 0) + this.destroyedStructures.size()];
        if (additionalPreviews) {
            this.previews.convertToSmallest();
            actions[0] = new LittleActionPlaceAbsolute(this.previews, PlacementMode.fill, true);
        }
        for (int i = 0; i < this.destroyedStructures.size(); ++i) {
            actions[additionalPreviews ? 1 : 0 + i] = this.destroyedStructures.get(i).getPlaceAction();
        }
        return new LittleActionCombined(actions);
    }

    public static List<LittleTile> removeBox(TileEntityLittleTiles te, LittleGridContext context, LittleTileBox toCut, boolean preventUpdate) {
        if (preventUpdate) {
            te.preventUpdate = true;
        }
        if (context != te.getContext()) {
            if (context.size > te.getContext().size) {
                te.convertTo(context);
            } else {
                toCut.convertTo(context, te.getContext());
                context = te.getContext();
            }
        }
        ArrayList<LittleTile> removed = new ArrayList<LittleTile>();
        for (LittleTile tile : te.getTiles()) {
            if (!tile.intersectsWith(toCut) || tile.isChildOfStructure() || !tile.canBeSplitted()) continue;
            tile.destroy();
            if (!tile.equalsBox(toCut)) {
                LittleTile copy;
                double volume = 0.0;
                LittleTilePreview preview = tile.getPreviewTile();
                ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
                boxes.add(toCut);
                List<LittleTileBox> newBoxes = tile.cutOut(boxes, cutout);
                if (newBoxes == null) continue;
                for (LittleTileBox box : newBoxes) {
                    copy = tile.copy();
                    copy.box = box;
                    copy.place();
                }
                for (LittleTileBox box : cutout) {
                    copy = tile.copy();
                    copy.box = box;
                    removed.add(copy);
                }
                continue;
            }
            removed.add(tile);
        }
        if (preventUpdate) {
            te.preventUpdate = false;
            te.combineTiles();
        }
        return removed;
    }

    public static List<LittleTile> removeBoxes(TileEntityLittleTiles te, LittleGridContext context, List<LittleTileBox> boxes) {
        te.preventUpdate = true;
        if (context != te.getContext()) {
            if (context.size > te.getContext().size) {
                te.convertTo(context);
            } else {
                for (LittleTileBox box : boxes) {
                    box.convertTo(context, te.getContext());
                }
                context = te.getContext();
            }
        }
        ArrayList<LittleTile> removed = new ArrayList<LittleTile>();
        for (LittleTile tile : te.getTiles()) {
            LittleTileBox intersecting = null;
            boolean intersects = false;
            for (int j = 0; j < boxes.size(); ++j) {
                if (!tile.intersectsWith(boxes.get(j))) continue;
                intersects = true;
                intersecting = boxes.get(j);
                break;
            }
            if (!intersects || tile.isChildOfStructure() || !tile.canBeSplitted()) continue;
            tile.destroy();
            if (!tile.equalsBox(intersecting)) {
                LittleTile copy;
                double volume = 0.0;
                LittleTilePreview preview = tile.getPreviewTile();
                ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                List<LittleTileBox> newBoxes = tile.cutOut(boxes, cutout);
                if (newBoxes == null) continue;
                for (LittleTileBox box : newBoxes) {
                    copy = tile.copy();
                    copy.box = box;
                    copy.place();
                }
                for (LittleTileBox box : cutout) {
                    copy = tile.copy();
                    copy.box = box;
                    removed.add(copy);
                }
                continue;
            }
            removed.add(tile);
        }
        te.preventUpdate = false;
        te.combineTiles();
        return removed;
    }

    public static class LittleActionDestroyBoxesFiltered
    extends LittleActionDestroyBoxes {
        public TileSelector selector;

        public LittleActionDestroyBoxesFiltered(LittleBoxes boxes, TileSelector selector) {
            super(boxes);
            this.selector = selector;
        }

        public LittleActionDestroyBoxesFiltered() {
        }

        @Override
        public void writeBytes(ByteBuf buf) {
            super.writeBytes(buf);
            LittleActionDestroyBoxesFiltered.writeSelector(this.selector, buf);
        }

        @Override
        public void readBytes(ByteBuf buf) {
            super.readBytes(buf);
            this.selector = LittleActionDestroyBoxesFiltered.readSelector(buf);
        }

        @Override
        public boolean shouldSkipTile(LittleTile tile) {
            return !this.selector.is(tile);
        }
    }
}

