/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.client;

import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.client.StepupHandler;
import com.therandomlabs.randomtweaks.client.TimeOfDayOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="randomtweaks")
public final class KeyBindingHandler {
    public static final KeyBinding TOGGLE_FOV_CHANGES = new KeyBinding("key.toggleFoVChanges", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, 51, "key.categories.randomtweaks");
    public static final KeyBinding RELOAD_SOUND_SYSTEM = new KeyBinding("key.reloadSoundSystem", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, 66, "key.categories.randomtweaks");
    public static final KeyBinding TOGGLE_TIME_OF_DAY_OVERLAY = new KeyBinding("key.toggleTimeOfDayOverlay", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 43, "key.categories.randomtweaks");
    public static final KeyBinding TOGGLE_AUTO_JUMP = new KeyBinding("key.toggleAutoJump", (IKeyConflictContext)KeyConflictContext.IN_GAME, 48, "key.categories.randomtweaks");
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean categoryEnabled;

    public static void registerKeyBindings() {
        categoryEnabled = false;
        KeyBindingHandler.register(RTConfig.keybinds.toggleFoVChanges, TOGGLE_FOV_CHANGES);
        KeyBindingHandler.register(RTConfig.keybinds.reloadSoundSystem, RELOAD_SOUND_SYSTEM);
        KeyBindingHandler.register(RTConfig.timeOfDay.enabled && RTConfig.keybinds.toggleTimeOfDayOverlay, TOGGLE_TIME_OF_DAY_OVERLAY);
        KeyBindingHandler.register(RTConfig.client.stepup, TOGGLE_AUTO_JUMP);
        if (categoryEnabled) {
            KeyBinding.func_151467_c().add("key.categories.randomtweaks");
        } else {
            KeyBinding.func_151467_c().remove("key.categories.randomtweaks");
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.getModID().equals("randomtweaks")) {
            KeyBindingHandler.registerKeyBindings();
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (!Keyboard.getEventKeyState()) {
            return;
        }
        int key = Keyboard.getEventKey();
        if (TOGGLE_FOV_CHANGES.isActiveAndMatches(key)) {
            if (RTConfig.keybinds.toggleFoVChanges) {
                KeyBindingHandler.toggleFoVChanges();
            }
        } else if (RELOAD_SOUND_SYSTEM.isActiveAndMatches(key)) {
            if (RTConfig.keybinds.reloadSoundSystem) {
                KeyBindingHandler.reloadSoundSystem();
            }
        } else if (TOGGLE_TIME_OF_DAY_OVERLAY.isActiveAndMatches(key)) {
            if (RTConfig.timeOfDay.enabled && RTConfig.keybinds.toggleTimeOfDayOverlay) {
                TimeOfDayOverlay.toggle();
            }
        } else if (TOGGLE_AUTO_JUMP.isActiveAndMatches(key) && RTConfig.client.stepup) {
            StepupHandler.toggle();
        }
    }

    public static void toggleFoVChanges() {
        RTConfig.Data data = RTConfig.Data.get();
        data.fovChanges = !data.fovChanges;
        RTConfig.Data.save();
        if (RTConfig.keybinds.fovChangesStatusMessage) {
            KeyBindingHandler.mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("toggleFoVChanges." + (data.fovChanges ? "enabled" : "disabled"), new Object[0]), true);
        }
    }

    public static void reloadSoundSystem() {
        if (!(RTConfig.keybinds.reloadSoundSystem && Keyboard.getEventKeyState() && RELOAD_SOUND_SYSTEM.isActiveAndMatches(Keyboard.getEventKey()))) {
            return;
        }
        KeyBindingHandler.mc.func_147118_V().field_147694_f.func_148596_a();
        KeyBindingHandler.mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("reloadSoundSystem.success", new Object[0]), true);
    }

    private static void register(boolean flag, KeyBinding keyBinding) {
        GameSettings gameSettings = KeyBindingHandler.mc.field_71474_y;
        if (flag) {
            if (!ArrayUtils.contains((Object[])gameSettings.field_74324_K, (Object)keyBinding)) {
                gameSettings.field_74324_K = (KeyBinding[])ArrayUtils.add((Object[])gameSettings.field_74324_K, (Object)keyBinding);
            }
            categoryEnabled = true;
        } else {
            int index = ArrayUtils.indexOf((Object[])gameSettings.field_74324_K, (Object)keyBinding);
            if (index != -1) {
                gameSettings.field_74324_K = (KeyBinding[])ArrayUtils.remove((Object[])gameSettings.field_74324_K, (int)index);
            }
        }
    }
}

