/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.booster;

import java.util.List;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ModuleSupport;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.booster.BoosterConfiguration;
import mcjty.rftools.blocks.environmental.EnvModuleProvider;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class BoosterTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final String CMD_RSMODE = "booster.setRsMode";
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_MODULE = 0;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/booster.gui"));
    static final ModuleSupport MODULE_SUPPORT = new ModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof EnvModuleProvider;
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 1);
    private AxisAlignedBB beamBox = null;
    private int timeout = 0;
    private EnvironmentModule cachedModule;

    public BoosterTileEntity() {
        super((long)BoosterConfiguration.BOOSTER_MAXENERGY, (long)BoosterConfiguration.BOOSTER_RECEIVEPERTICK);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            ItemStack stack;
            if (this.timeout > 0) {
                --this.timeout;
                this.func_70296_d();
                return;
            }
            if (this.cachedModule == null && !(stack = this.inventoryHelper.getStackInSlot(0)).func_190926_b() && stack.func_77973_b() instanceof EnvModuleProvider) {
                EnvModuleProvider provider = (EnvModuleProvider)stack.func_77973_b();
                Class<? extends EnvironmentModule> clazz = provider.getServerEnvironmentModule();
                try {
                    this.cachedModule = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.cachedModule != null) {
                long rf = this.getStoredPower();
                int rfNeeded = (int)(this.cachedModule.getRfPerTick() * BoosterConfiguration.energyMultiplier);
                rfNeeded = (int)((float)rfNeeded * (3.0f - this.getInfusedFactor()) / 3.0f);
                for (EntityLivingBase entity : this.searchEntities()) {
                    if ((long)rfNeeded > rf || !this.cachedModule.apply(this.func_145831_w(), this.func_174877_v(), entity, 40)) continue;
                    this.consumeEnergy(rfNeeded);
                    rf -= (long)rfNeeded;
                }
                this.timeout = 10;
                this.func_70296_d();
            }
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.cachedModule = null;
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.cachedModule = null;
        return this.getInventoryHelper().decrStackSize(index, count);
    }

    private List<EntityLivingBase> searchEntities() {
        if (this.beamBox == null) {
            int xCoord = this.func_174877_v().func_177958_n();
            int yCoord = this.func_174877_v().func_177956_o();
            int zCoord = this.func_174877_v().func_177952_p();
            this.beamBox = new AxisAlignedBB((double)xCoord, (double)(yCoord + 1), (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 3), (double)(zCoord + 1));
        }
        return this.func_145831_w().func_72872_a(EntityLivingBase.class, this.beamBox);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            this.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]);
            return true;
        }
        return false;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int[] func_180463_a(EnumFacing side) {
        return CONTAINER_FACTORY.getAccessibleSlots();
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return CONTAINER_FACTORY.isOutputSlot(index);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return CONTAINER_FACTORY.isInputSlot(index);
    }
}

