/*
 * Decompiled with CFR 0.152.
 */
package quaternary.simpletrophies.client.tesr;

import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import quaternary.simpletrophies.SimpleTrophies;
import quaternary.simpletrophies.client.ClientGameEvents;
import quaternary.simpletrophies.common.block.BlockSimpleTrophy;
import quaternary.simpletrophies.common.etc.EnumTrophyVariant;
import quaternary.simpletrophies.common.etc.TrophyHelpers;
import quaternary.simpletrophies.common.item.ItemSimpleTrophy;

public class RenderItemStackSimpleTrophy
extends TileEntityItemStackRenderer {
    static final ModelResourceLocation[] baseModels = new ModelResourceLocation[EnumTrophyVariant.VALUES.length];
    int recursionDepth = 0;

    public void func_179022_a(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemSimpleTrophy)) {
            return;
        }
        int variantID = TrophyHelpers.getDisplayedVariant(stack).ordinal();
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        ModelManager mm = brd.func_175023_a().func_178126_b();
        int color = TrophyHelpers.getCombinedColor(stack);
        float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        brd.func_175019_b().func_178262_a(mm.func_174953_a(baseModels[variantID]), 1.0f, red, green, blue);
        ItemStack displayedStack = TrophyHelpers.getDisplayedStack(stack);
        if (!displayedStack.func_190926_b()) {
            float ticks = ClientGameEvents.getPauseAdjustedTicksAndPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.55, (double)0.5);
            if (!Minecraft.func_71410_x().func_175599_af().func_184393_a(displayedStack, (World)Minecraft.func_71410_x().field_71441_e, null).func_177556_c()) {
                GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            }
            GlStateManager.func_179114_b((float)(ticks * 2.5f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            ++this.recursionDepth;
            if (this.recursionDepth < 5) {
                try {
                    Minecraft.func_71410_x().func_175599_af().func_181564_a(displayedStack, ItemCameraTransforms.TransformType.GROUND);
                }
                catch (Exception oof) {
                    SimpleTrophies.LOG.error("Problem rendering item on a trophy TEISR", (Throwable)oof);
                }
            }
            --this.recursionDepth;
            GlStateManager.func_179147_l();
            GlStateManager.func_179121_F();
        }
    }

    static {
        PropertyEnum<EnumTrophyVariant> propVariant = BlockSimpleTrophy.PROP_VARIANT;
        String variantName = propVariant.func_177701_a();
        for (int i = 0; i < EnumTrophyVariant.VALUES.length; ++i) {
            EnumTrophyVariant var = EnumTrophyVariant.VALUES[i];
            RenderItemStackSimpleTrophy.baseModels[i] = new ModelResourceLocation(new ResourceLocation("simple_trophies", "trophy"), variantName + '=' + propVariant.func_177702_a((Enum)var));
        }
    }
}

