/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.CheckBox;
import vswe.superfactory.components.CheckBoxList;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.components.internal.ConnectionSet;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuRedstoneStrength
extends ComponentMenu {
    private static final int CHECK_BOX_X = 5;
    private static final int CHECK_BOX_Y = 50;
    private static final int MENU_WIDTH = 120;
    private static final String NBT_HIGH = "HighRange";
    private static final String NBT_INVERTED = "Inverted";
    private static final String NBT_LOW = "LowRange";
    private static final int TEXT_BOX_TEXT_X = 46;
    private static final int TEXT_BOX_TEXT_Y = 33;
    private static final int TEXT_BOX_X_LEFT = 10;
    private static final int TEXT_BOX_X_RIGHT = 77;
    private static final int TEXT_BOX_Y = 30;
    private static final int TEXT_MARGIN_X = 5;
    private static final int TEXT_Y = 5;
    private CheckBoxList checkBoxes = new CheckBoxList();
    private TextBoxNumber highTextBox;
    private boolean inverted;
    private TextBoxNumber lowTextBox;
    private TextBoxNumberList textBoxes;

    public ComponentMenuRedstoneStrength(FlowComponent parent) {
        super(parent);
        this.checkBoxes.addCheckBox(new CheckBox(Localization.INVERT_SELECTION, 5, 50){

            @Override
            public boolean getValue() {
                return ComponentMenuRedstoneStrength.this.inverted;
            }

            @Override
            public void setValue(boolean val) {
                ComponentMenuRedstoneStrength.this.inverted = val;
            }

            @Override
            public void onUpdate() {
                ComponentMenuRedstoneStrength.this.sendServerData(2);
            }
        });
        this.textBoxes = new TextBoxNumberList();
        this.lowTextBox = new TextBoxNumber(10, 30, 2, true){

            @Override
            public int getMaxNumber() {
                return 15;
            }

            @Override
            public void onNumberChanged() {
                ComponentMenuRedstoneStrength.this.sendServerData(0);
            }
        };
        this.textBoxes.addTextBox(this.lowTextBox);
        this.highTextBox = new TextBoxNumber(77, 30, 2, true){

            @Override
            public void onNumberChanged() {
                ComponentMenuRedstoneStrength.this.sendServerData(1);
            }

            @Override
            public int getMaxNumber() {
                return 15;
            }
        };
        this.textBoxes.addTextBox(this.highTextBox);
        this.lowTextBox.setNumber(1);
        this.highTextBox.setNumber(15);
    }

    private void sendServerData(int id) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, id);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, int id) {
        boolean isTextBox = id != 2;
        dw.writeBoolean(isTextBox);
        if (isTextBox) {
            boolean isHigh = id == 1;
            dw.writeBoolean(isHigh);
            TextBoxNumber textBox = isHigh ? this.highTextBox : this.lowTextBox;
            dw.writeData(textBox.getNumber(), DataBitHelper.MENU_REDSTONE_ANALOG);
        } else {
            dw.writeBoolean(this.inverted);
        }
    }

    @Override
    public String getName() {
        return Localization.REDSTONE_STRENGTH_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        gui.drawSplitString(Localization.REDSTONE_STRENGTH_INFO.toString(), 5, 5, 110, 0.7f, 0x404040);
        gui.drawString(Localization.THROUGH.toString(), 46, 33, 0.7f, 0x404040);
        this.checkBoxes.draw(gui, mX, mY);
        this.textBoxes.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.checkBoxes.onClick(mX, mY);
        this.textBoxes.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        return this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(this.lowTextBox.getNumber(), DataBitHelper.MENU_REDSTONE_ANALOG);
        dw.writeData(this.highTextBox.getNumber(), DataBitHelper.MENU_REDSTONE_ANALOG);
        dw.writeBoolean(this.inverted);
    }

    @Override
    public void readData(DataReader dr) {
        this.lowTextBox.setNumber(dr.readData(DataBitHelper.MENU_REDSTONE_ANALOG));
        this.highTextBox.setNumber(dr.readData(DataBitHelper.MENU_REDSTONE_ANALOG));
        this.inverted = dr.readBoolean();
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuRedstoneStrength menuStrength = (ComponentMenuRedstoneStrength)menu;
        this.lowTextBox.setNumber(menuStrength.lowTextBox.getNumber());
        this.highTextBox.setNumber(menuStrength.highTextBox.getNumber());
        this.inverted = menuStrength.inverted;
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuRedstoneStrength newDataStrength = (ComponentMenuRedstoneStrength)newData;
        if (this.lowTextBox.getNumber() != newDataStrength.lowTextBox.getNumber()) {
            this.lowTextBox.setNumber(newDataStrength.lowTextBox.getNumber());
            this.sendClientData(container, 0);
        }
        if (this.highTextBox.getNumber() != newDataStrength.highTextBox.getNumber()) {
            this.highTextBox.setNumber(newDataStrength.highTextBox.getNumber());
            this.sendClientData(container, 1);
        }
        if (this.inverted != newDataStrength.inverted) {
            this.inverted = newDataStrength.inverted;
            this.sendClientData(container, 2);
        }
    }

    private void sendClientData(ContainerManager container, int id) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, id);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.lowTextBox.setNumber(nbtTagCompound.func_74771_c(NBT_LOW));
        this.highTextBox.setNumber(nbtTagCompound.func_74771_c(NBT_HIGH));
        this.inverted = nbtTagCompound.func_74767_n(NBT_INVERTED);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_LOW, (byte)this.lowTextBox.getNumber());
        nbtTagCompound.func_74774_a(NBT_HIGH, (byte)this.highTextBox.getNumber());
        nbtTagCompound.func_74757_a(NBT_INVERTED, this.inverted);
    }

    @Override
    public void addErrors(List<String> errors) {
        if (this.getLow() > this.getHigh()) {
            errors.add(Localization.INVALID_REDSTONE_RANGE_ERROR.toString());
        } else if (this.getLow() == 0 && this.getHigh() == 15) {
            errors.add(Localization.REDUNDANT_REDSTONE_RANGE_ERROR.toString());
        }
    }

    @Override
    public boolean isVisible() {
        return this.getParent().getConnectionSet() == ConnectionSet.REDSTONE;
    }

    public int getLow() {
        return this.lowTextBox.getNumber();
    }

    public int getHigh() {
        return this.highTextBox.getNumber();
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        if (dr.readBoolean()) {
            TextBoxNumber textBox = dr.readBoolean() ? this.highTextBox : this.lowTextBox;
            textBox.setNumber(dr.readData(DataBitHelper.MENU_REDSTONE_ANALOG));
        } else {
            this.inverted = dr.readBoolean();
        }
    }

    public boolean isInverted() {
        return this.inverted;
    }
}

